/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.CompanyCodeStdVHSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVH CompanyCodeStdVH}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class CompanyCodeStdVHByKeyFluentHelper
    extends
    FluentHelperByKey<CompanyCodeStdVHByKeyFluentHelper, CompanyCodeStdVH, CompanyCodeStdVHSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVH CompanyCodeStdVH}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CompanyCodeStdVH}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CompanyCodeStdVH}
     */
    public CompanyCodeStdVHByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String companyCode )
    {
        super(servicePath, entityCollection);
        this.key.put("CompanyCode", companyCode);
    }

    @Override
    @Nonnull
    protected Class<CompanyCodeStdVH> getEntityClass()
    {
        return CompanyCodeStdVH.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
