/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.ControllingObjectStdVHSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVH
 * ControllingObjectStdVH} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ControllingObjectStdVHByKeyFluentHelper
    extends
    FluentHelperByKey<ControllingObjectStdVHByKeyFluentHelper, ControllingObjectStdVH, ControllingObjectStdVHSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVH
     * ControllingObjectStdVH} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ControllingObjectStdVH}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ControllingObjectStdVH}
     * @param controllingObject
     *            Object Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 22
     *            </p>
     */
    public ControllingObjectStdVHByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String controllingObject )
    {
        super(servicePath, entityCollection);
        this.key.put("ControllingObject", controllingObject);
    }

    @Override
    @Nonnull
    protected Class<ControllingObjectStdVH> getEntityClass()
    {
        return ControllingObjectStdVH.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
