/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.CreditControlAreaStdVHField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.CreditControlAreaStdVHSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Credit Control Area
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>I_CreditControlAreaStdVHType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CreditControlAreaStdVH extends VdmEntity<CreditControlAreaStdVH>
{

    /**
     * Selector for all available fields of CreditControlAreaStdVH.
     *
     */
    public final static CreditControlAreaStdVHSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea</b>
     * </p>
     *
     * @return Credit Control Area
     */
    @Key
    @SerializedName( "CreditControlArea" )
    @JsonProperty( "CreditControlArea" )
    @Nullable
    @ODataField( odataName = "CreditControlArea" )
    private String creditControlArea;
    /**
     * Use with available fluent helpers to apply the <b>CreditControlArea</b> field to query operations.
     *
     */
    public final static CreditControlAreaStdVHField<String> CREDIT_CONTROL_AREA =
        new CreditControlAreaStdVHField<String>("CreditControlArea");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea_Text</b>
     * </p>
     *
     * @return Description of the credit control area
     */
    @SerializedName( "CreditControlArea_Text" )
    @JsonProperty( "CreditControlArea_Text" )
    @Nullable
    @ODataField( odataName = "CreditControlArea_Text" )
    private String creditControlArea_Text;
    /**
     * Use with available fluent helpers to apply the <b>CreditControlArea_Text</b> field to query operations.
     *
     */
    public final static CreditControlAreaStdVHField<String> CREDIT_CONTROL_AREA_TEXT =
        new CreditControlAreaStdVHField<String>("CreditControlArea_Text");

    @Nonnull
    @Override
    public Class<CreditControlAreaStdVH> getType()
    {
        return CreditControlAreaStdVH.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea</b>
     * </p>
     *
     * @param creditControlArea
     *            Credit Control Area
     */
    public void setCreditControlArea( @Nullable final String creditControlArea )
    {
        rememberChangedField("CreditControlArea", this.creditControlArea);
        this.creditControlArea = creditControlArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea_Text</b>
     * </p>
     *
     * @param creditControlArea_Text
     *            Description of the credit control area
     */
    public void setCreditControlArea_Text( @Nullable final String creditControlArea_Text )
    {
        rememberChangedField("CreditControlArea_Text", this.creditControlArea_Text);
        this.creditControlArea_Text = creditControlArea_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "I_CreditControlAreaStdVH";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CreditControlArea", getCreditControlArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CreditControlArea", getCreditControlArea());
        values.put("CreditControlArea_Text", getCreditControlArea_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CreditControlArea") ) {
                final Object value = values.remove("CreditControlArea");
                if( (value == null) || (!value.equals(getCreditControlArea())) ) {
                    setCreditControlArea(((String) value));
                }
            }
            if( values.containsKey("CreditControlArea_Text") ) {
                final Object value = values.remove("CreditControlArea_Text");
                if( (value == null) || (!value.equals(getCreditControlArea_Text())) ) {
                    setCreditControlArea_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CreditControlAreaStdVHField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CreditControlAreaStdVHField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CreditControlAreaStdVHField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CreditControlAreaStdVHField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService.DEFAULT_SERVICE_PATH);
    }

}
