/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
 * CreditMemoReqPartner} entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class CreditMemoReqPartnerDeleteFluentHelper
    extends
    FluentHelperDelete<CreditMemoReqPartnerDeleteFluentHelper, CreditMemoReqPartner>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     * CreditMemoReqPartner} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final CreditMemoReqPartner entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     * CreditMemoReqPartner} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The CreditMemoReqPartner to delete from the endpoint.
     */
    public CreditMemoReqPartnerDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final CreditMemoReqPartner entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected CreditMemoReqPartner getEntity()
    {
        return entity;
    }

}
