/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.CreditMemoReqPrcgElmntField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.CreditMemoReqPrcgElmntOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.CreditMemoReqPrcgElmntSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Pricing Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CreditMemoReqPrcgElmntType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CreditMemoReqPrcgElmnt extends VdmEntity<CreditMemoReqPrcgElmnt>
{

    /**
     * Selector for all available fields of CreditMemoReqPrcgElmnt.
     *
     */
    public final static CreditMemoReqPrcgElmntSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequest</b>
     * </p>
     *
     * @return Sales Document
     */
    @Key
    @SerializedName( "CreditMemoRequest" )
    @JsonProperty( "CreditMemoRequest" )
    @Nullable
    @ODataField( odataName = "CreditMemoRequest" )
    private String creditMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>CreditMemoRequest</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CREDIT_MEMO_REQUEST =
        new CreditMemoReqPrcgElmntField<String>("CreditMemoRequest");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @return Step Number
     */
    @Key
    @SerializedName( "PricingProcedureStep" )
    @JsonProperty( "PricingProcedureStep" )
    @Nullable
    @ODataField( odataName = "PricingProcedureStep" )
    private String pricingProcedureStep;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureStep</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> PRICING_PROCEDURE_STEP =
        new CreditMemoReqPrcgElmntField<String>("PricingProcedureStep");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @return Condition Counter
     */
    @Key
    @SerializedName( "PricingProcedureCounter" )
    @JsonProperty( "PricingProcedureCounter" )
    @Nullable
    @ODataField( odataName = "PricingProcedureCounter" )
    private String pricingProcedureCounter;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureCounter</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> PRICING_PROCEDURE_COUNTER =
        new CreditMemoReqPrcgElmntField<String>("PricingProcedureCounter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_APPLICATION =
        new CreditMemoReqPrcgElmntField<String>("ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_TYPE =
        new CreditMemoReqPrcgElmntField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateTime</b>
     * </p>
     *
     * @return Timestamp for Pricing
     */
    @SerializedName( "PricingDateTime" )
    @JsonProperty( "PricingDateTime" )
    @Nullable
    @ODataField( odataName = "PricingDateTime" )
    private String pricingDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PricingDateTime</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> PRICING_DATE_TIME =
        new CreditMemoReqPrcgElmntField<String>("PricingDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceConditionDeterminationDte</b>
     * </p>
     *
     * @return Condition Pricing Date
     */
    @SerializedName( "PriceConditionDeterminationDte" )
    @JsonProperty( "PriceConditionDeterminationDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PriceConditionDeterminationDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime priceConditionDeterminationDte;
    /**
     * Use with available fluent helpers to apply the <b>PriceConditionDeterminationDte</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<LocalDateTime> PRICE_CONDITION_DETERMINATION_DTE =
        new CreditMemoReqPrcgElmntField<LocalDateTime>("PriceConditionDeterminationDte");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @return Calculation Type for Condition
     */
    @SerializedName( "ConditionCalculationType" )
    @JsonProperty( "ConditionCalculationType" )
    @Nullable
    @ODataField( odataName = "ConditionCalculationType" )
    private String conditionCalculationType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCalculationType</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_CALCULATION_TYPE =
        new CreditMemoReqPrcgElmntField<String>("ConditionCalculationType");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseValue</b>
     * </p>
     *
     * @return Condition Basis
     */
    @SerializedName( "ConditionBaseValue" )
    @JsonProperty( "ConditionBaseValue" )
    @Nullable
    @ODataField( odataName = "ConditionBaseValue" )
    private BigDecimal conditionBaseValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionBaseValue</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CONDITION_BASE_VALUE =
        new CreditMemoReqPrcgElmntField<BigDecimal>("ConditionBaseValue");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CONDITION_RATE_VALUE =
        new CreditMemoReqPrcgElmntField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_CURRENCY =
        new CreditMemoReqPrcgElmntField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CONDITION_QUANTITY =
        new CreditMemoReqPrcgElmntField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit in the Document
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_QUANTITY_UNIT =
        new CreditMemoReqPrcgElmntField<String>("ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for Converting to Base UoM
     */
    @SerializedName( "ConditionToBaseQtyNmrtr" )
    @JsonProperty( "ConditionToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyNmrtr" )
    private BigDecimal conditionToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CONDITION_TO_BASE_QTY_NMRTR =
        new CreditMemoReqPrcgElmntField<BigDecimal>("ConditionToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for Converting to Base UoM
     */
    @SerializedName( "ConditionToBaseQtyDnmntr" )
    @JsonProperty( "ConditionToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyDnmntr" )
    private BigDecimal conditionToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CONDITION_TO_BASE_QTY_DNMNTR =
        new CreditMemoReqPrcgElmntField<BigDecimal>("ConditionToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     *
     * @return Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    @SerializedName( "ConditionCategory" )
    @JsonProperty( "ConditionCategory" )
    @Nullable
    @ODataField( odataName = "ConditionCategory" )
    private String conditionCategory;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCategory</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_CATEGORY =
        new CreditMemoReqPrcgElmntField<String>("ConditionCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     *
     * @return Condition is used for statistics
     */
    @SerializedName( "ConditionIsForStatistics" )
    @JsonProperty( "ConditionIsForStatistics" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsForStatistics" )
    private Boolean conditionIsForStatistics;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsForStatistics</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<Boolean> CONDITION_IS_FOR_STATISTICS =
        new CreditMemoReqPrcgElmntField<Boolean>("ConditionIsForStatistics");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @return Scale Type
     */
    @SerializedName( "PricingScaleType" )
    @JsonProperty( "PricingScaleType" )
    @Nullable
    @ODataField( odataName = "PricingScaleType" )
    private String pricingScaleType;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleType</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> PRICING_SCALE_TYPE =
        new CreditMemoReqPrcgElmntField<String>("PricingScaleType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     *
     * @return Condition is Relevant for Accrual (e.g. Freight)
     */
    @SerializedName( "IsRelevantForAccrual" )
    @JsonProperty( "IsRelevantForAccrual" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsRelevantForAccrual" )
    private Boolean isRelevantForAccrual;
    /**
     * Use with available fluent helpers to apply the <b>IsRelevantForAccrual</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<Boolean> IS_RELEVANT_FOR_ACCRUAL =
        new CreditMemoReqPrcgElmntField<Boolean>("IsRelevantForAccrual");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForInvoiceList</b>
     * </p>
     *
     * @return Condition for Invoice List
     */
    @SerializedName( "CndnIsRelevantForInvoiceList" )
    @JsonProperty( "CndnIsRelevantForInvoiceList" )
    @Nullable
    @ODataField( odataName = "CndnIsRelevantForInvoiceList" )
    private String cndnIsRelevantForInvoiceList;
    /**
     * Use with available fluent helpers to apply the <b>CndnIsRelevantForInvoiceList</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CNDN_IS_RELEVANT_FOR_INVOICE_LIST =
        new CreditMemoReqPrcgElmntField<String>("CndnIsRelevantForInvoiceList");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionOrigin</b>
     * </p>
     *
     * @return Origin of the Condition
     */
    @SerializedName( "ConditionOrigin" )
    @JsonProperty( "ConditionOrigin" )
    @Nullable
    @ODataField( odataName = "ConditionOrigin" )
    private String conditionOrigin;
    /**
     * Use with available fluent helpers to apply the <b>ConditionOrigin</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_ORIGIN =
        new CreditMemoReqPrcgElmntField<String>("ConditionOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     *
     * @return Group Condition
     */
    @SerializedName( "IsGroupCondition" )
    @JsonProperty( "IsGroupCondition" )
    @Nullable
    @ODataField( odataName = "IsGroupCondition" )
    private String isGroupCondition;
    /**
     * Use with available fluent helpers to apply the <b>IsGroupCondition</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> IS_GROUP_CONDITION =
        new CreditMemoReqPrcgElmntField<String>("IsGroupCondition");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccessNumberOfAccessSequence</b>
     * </p>
     *
     * @return Access sequence - Access number
     */
    @SerializedName( "AccessNumberOfAccessSequence" )
    @JsonProperty( "AccessNumberOfAccessSequence" )
    @Nullable
    @ODataField( odataName = "AccessNumberOfAccessSequence" )
    private String accessNumberOfAccessSequence;
    /**
     * Use with available fluent helpers to apply the <b>AccessNumberOfAccessSequence</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> ACCESS_NUMBER_OF_ACCESS_SEQUENCE =
        new CreditMemoReqPrcgElmntField<String>("AccessNumberOfAccessSequence");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_RECORD =
        new CreditMemoReqPrcgElmntField<String>("ConditionRecord");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential Number of the Condition
     */
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_SEQUENTIAL_NUMBER =
        new CreditMemoReqPrcgElmntField<String>("ConditionSequentialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> TAX_CODE =
        new CreditMemoReqPrcgElmntField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     *
     * @return Withholding tax code
     */
    @SerializedName( "WithholdingTaxCode" )
    @JsonProperty( "WithholdingTaxCode" )
    @Nullable
    @ODataField( odataName = "WithholdingTaxCode" )
    private String withholdingTaxCode;
    /**
     * Use with available fluent helpers to apply the <b>WithholdingTaxCode</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> WITHHOLDING_TAX_CODE =
        new CreditMemoReqPrcgElmntField<String>("WithholdingTaxCode");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnRoundingOffDiffAmount</b>
     * </p>
     *
     * @return Rounding-Off Difference of the Condition
     */
    @SerializedName( "CndnRoundingOffDiffAmount" )
    @JsonProperty( "CndnRoundingOffDiffAmount" )
    @Nullable
    @ODataField( odataName = "CndnRoundingOffDiffAmount" )
    private BigDecimal cndnRoundingOffDiffAmount;
    /**
     * Use with available fluent helpers to apply the <b>CndnRoundingOffDiffAmount</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CNDN_ROUNDING_OFF_DIFF_AMOUNT =
        new CreditMemoReqPrcgElmntField<BigDecimal>("CndnRoundingOffDiffAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmount</b>
     * </p>
     *
     * @return Condition Value
     */
    @SerializedName( "ConditionAmount" )
    @JsonProperty( "ConditionAmount" )
    @Nullable
    @ODataField( odataName = "ConditionAmount" )
    private BigDecimal conditionAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionAmount</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CONDITION_AMOUNT =
        new CreditMemoReqPrcgElmntField<BigDecimal>("ConditionAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> TRANSACTION_CURRENCY =
        new CreditMemoReqPrcgElmntField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionControl</b>
     * </p>
     *
     * @return Condition Control
     */
    @SerializedName( "ConditionControl" )
    @JsonProperty( "ConditionControl" )
    @Nullable
    @ODataField( odataName = "ConditionControl" )
    private String conditionControl;
    /**
     * Use with available fluent helpers to apply the <b>ConditionControl</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_CONTROL =
        new CreditMemoReqPrcgElmntField<String>("ConditionControl");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @return Condition is Inactive
     */
    @SerializedName( "ConditionInactiveReason" )
    @JsonProperty( "ConditionInactiveReason" )
    @Nullable
    @ODataField( odataName = "ConditionInactiveReason" )
    private String conditionInactiveReason;
    /**
     * Use with available fluent helpers to apply the <b>ConditionInactiveReason</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_INACTIVE_REASON =
        new CreditMemoReqPrcgElmntField<String>("ConditionInactiveReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     *
     * @return Condition Class
     */
    @SerializedName( "ConditionClass" )
    @JsonProperty( "ConditionClass" )
    @Nullable
    @ODataField( odataName = "ConditionClass" )
    private String conditionClass;
    /**
     * Use with available fluent helpers to apply the <b>ConditionClass</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_CLASS =
        new CreditMemoReqPrcgElmntField<String>("ConditionClass");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedureCounterForHeader</b>
     * </p>
     *
     * @return Condition Counter (Header)
     */
    @SerializedName( "PrcgProcedureCounterForHeader" )
    @JsonProperty( "PrcgProcedureCounterForHeader" )
    @Nullable
    @ODataField( odataName = "PrcgProcedureCounterForHeader" )
    private String prcgProcedureCounterForHeader;
    /**
     * Use with available fluent helpers to apply the <b>PrcgProcedureCounterForHeader</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> PRCG_PROCEDURE_COUNTER_FOR_HEADER =
        new CreditMemoReqPrcgElmntField<String>("PrcgProcedureCounterForHeader");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FactorForConditionBasisValue</b>
     * </p>
     *
     * @return Factor for Condition Base Value
     */
    @SerializedName( "FactorForConditionBasisValue" )
    @JsonProperty( "FactorForConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "FactorForConditionBasisValue" )
    private Double factorForConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>FactorForConditionBasisValue</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<Double> FACTOR_FOR_CONDITION_BASIS_VALUE =
        new CreditMemoReqPrcgElmntField<Double>("FactorForConditionBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StructureCondition</b>
     * </p>
     *
     * @return Structure Condition
     */
    @SerializedName( "StructureCondition" )
    @JsonProperty( "StructureCondition" )
    @Nullable
    @ODataField( odataName = "StructureCondition" )
    private String structureCondition;
    /**
     * Use with available fluent helpers to apply the <b>StructureCondition</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> STRUCTURE_CONDITION =
        new CreditMemoReqPrcgElmntField<String>("StructureCondition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PeriodFactorForCndnBasisValue</b>
     * </p>
     *
     * @return Factor for Condition Basis (Period)
     */
    @SerializedName( "PeriodFactorForCndnBasisValue" )
    @JsonProperty( "PeriodFactorForCndnBasisValue" )
    @Nullable
    @ODataField( odataName = "PeriodFactorForCndnBasisValue" )
    private Double periodFactorForCndnBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>PeriodFactorForCndnBasisValue</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<Double> PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE =
        new CreditMemoReqPrcgElmntField<Double>("PeriodFactorForCndnBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @return Scale Basis Indicator
     */
    @SerializedName( "PricingScaleBasis" )
    @JsonProperty( "PricingScaleBasis" )
    @Nullable
    @ODataField( odataName = "PricingScaleBasis" )
    private String pricingScaleBasis;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleBasis</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> PRICING_SCALE_BASIS =
        new CreditMemoReqPrcgElmntField<String>("PricingScaleBasis");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisValue</b>
     * </p>
     *
     * @return Scale Base Value
     */
    @SerializedName( "ConditionScaleBasisValue" )
    @JsonProperty( "ConditionScaleBasisValue" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisValue" )
    private BigDecimal conditionScaleBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisValue</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CONDITION_SCALE_BASIS_VALUE =
        new CreditMemoReqPrcgElmntField<BigDecimal>("ConditionScaleBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleBasisUnit" )
    @JsonProperty( "ConditionScaleBasisUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisUnit" )
    private String conditionScaleBasisUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisUnit</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_SCALE_BASIS_UNIT =
        new CreditMemoReqPrcgElmntField<String>("ConditionScaleBasisUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleBasisCurrency" )
    @JsonProperty( "ConditionScaleBasisCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisCurrency" )
    private String conditionScaleBasisCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisCurrency</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_SCALE_BASIS_CURRENCY =
        new CreditMemoReqPrcgElmntField<String>("ConditionScaleBasisCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAlternativeCurrency</b>
     * </p>
     *
     * @return Condition Currency (for Cumulation Fields)
     */
    @SerializedName( "ConditionAlternativeCurrency" )
    @JsonProperty( "ConditionAlternativeCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionAlternativeCurrency" )
    private String conditionAlternativeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionAlternativeCurrency</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> CONDITION_ALTERNATIVE_CURRENCY =
        new CreditMemoReqPrcgElmntField<String>("ConditionAlternativeCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmountInLocalCrcy</b>
     * </p>
     *
     * @return Condition Value
     */
    @SerializedName( "ConditionAmountInLocalCrcy" )
    @JsonProperty( "ConditionAmountInLocalCrcy" )
    @Nullable
    @ODataField( odataName = "ConditionAmountInLocalCrcy" )
    private BigDecimal conditionAmountInLocalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>ConditionAmountInLocalCrcy</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CONDITION_AMOUNT_IN_LOCAL_CRCY =
        new CreditMemoReqPrcgElmntField<BigDecimal>("ConditionAmountInLocalCrcy");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForIntcoBilling</b>
     * </p>
     *
     * @return Condition for Intercompany Billing
     */
    @SerializedName( "CndnIsRelevantForIntcoBilling" )
    @JsonProperty( "CndnIsRelevantForIntcoBilling" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CndnIsRelevantForIntcoBilling" )
    private Boolean cndnIsRelevantForIntcoBilling;
    /**
     * Use with available fluent helpers to apply the <b>CndnIsRelevantForIntcoBilling</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<Boolean> CNDN_IS_RELEVANT_FOR_INTCO_BILLING =
        new CreditMemoReqPrcgElmntField<Boolean>("CndnIsRelevantForIntcoBilling");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyChanged</b>
     * </p>
     *
     * @return Condition Changed Manually
     */
    @SerializedName( "ConditionIsManuallyChanged" )
    @JsonProperty( "ConditionIsManuallyChanged" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsManuallyChanged" )
    private Boolean conditionIsManuallyChanged;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsManuallyChanged</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<Boolean> CONDITION_IS_MANUALLY_CHANGED =
        new CreditMemoReqPrcgElmntField<Boolean>("ConditionIsManuallyChanged");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>CumulatedConditionBasisValue</b>
     * </p>
     *
     * @return Condition Basis
     */
    @SerializedName( "CumulatedConditionBasisValue" )
    @JsonProperty( "CumulatedConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "CumulatedConditionBasisValue" )
    private BigDecimal cumulatedConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>CumulatedConditionBasisValue</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<BigDecimal> CUMULATED_CONDITION_BASIS_VALUE =
        new CreditMemoReqPrcgElmntField<BigDecimal>("CumulatedConditionBasisValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForConfiguration</b>
     * </p>
     *
     * @return Condition Used for Variant Configuration
     */
    @SerializedName( "ConditionIsForConfiguration" )
    @JsonProperty( "ConditionIsForConfiguration" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsForConfiguration" )
    private Boolean conditionIsForConfiguration;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsForConfiguration</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<Boolean> CONDITION_IS_FOR_CONFIGURATION =
        new CreditMemoReqPrcgElmntField<Boolean>("ConditionIsForConfiguration");
    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     *
     * @return Variant Condition Key
     */
    @SerializedName( "VariantCondition" )
    @JsonProperty( "VariantCondition" )
    @Nullable
    @ODataField( odataName = "VariantCondition" )
    private String variantCondition;
    /**
     * Use with available fluent helpers to apply the <b>VariantCondition</b> field to query operations.
     *
     */
    public final static CreditMemoReqPrcgElmntField<String> VARIANT_CONDITION =
        new CreditMemoReqPrcgElmntField<String>("VariantCondition");
    /**
     * Navigation property <b>to_CreditMemoRequest</b> for <b>CreditMemoReqPrcgElmnt</b> to single
     * <b>CreditMemoRequest</b>.
     *
     */
    @SerializedName( "to_CreditMemoRequest" )
    @JsonProperty( "to_CreditMemoRequest" )
    @ODataField( odataName = "to_CreditMemoRequest" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CreditMemoRequest toCreditMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>to_CreditMemoRequest</b> navigation property to query
     * operations.
     *
     */
    public final static CreditMemoReqPrcgElmntOneToOneLink<CreditMemoRequest> TO_CREDIT_MEMO_REQUEST =
        new CreditMemoReqPrcgElmntOneToOneLink<CreditMemoRequest>("to_CreditMemoRequest");

    @Nonnull
    @Override
    public Class<CreditMemoReqPrcgElmnt> getType()
    {
        return CreditMemoReqPrcgElmnt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequest</b>
     * </p>
     *
     * @param creditMemoRequest
     *            Sales Document
     */
    public void setCreditMemoRequest( @Nullable final String creditMemoRequest )
    {
        rememberChangedField("CreditMemoRequest", this.creditMemoRequest);
        this.creditMemoRequest = creditMemoRequest;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @param pricingProcedureStep
     *            Step Number
     */
    public void setPricingProcedureStep( @Nullable final String pricingProcedureStep )
    {
        rememberChangedField("PricingProcedureStep", this.pricingProcedureStep);
        this.pricingProcedureStep = pricingProcedureStep;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     */
    public void setPricingProcedureCounter( @Nullable final String pricingProcedureCounter )
    {
        rememberChangedField("PricingProcedureCounter", this.pricingProcedureCounter);
        this.pricingProcedureCounter = pricingProcedureCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateTime</b>
     * </p>
     *
     * @param pricingDateTime
     *            Timestamp for Pricing
     */
    public void setPricingDateTime( @Nullable final String pricingDateTime )
    {
        rememberChangedField("PricingDateTime", this.pricingDateTime);
        this.pricingDateTime = pricingDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceConditionDeterminationDte</b>
     * </p>
     *
     * @param priceConditionDeterminationDte
     *            Condition Pricing Date
     */
    public void setPriceConditionDeterminationDte( @Nullable final LocalDateTime priceConditionDeterminationDte )
    {
        rememberChangedField("PriceConditionDeterminationDte", this.priceConditionDeterminationDte);
        this.priceConditionDeterminationDte = priceConditionDeterminationDte;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseValue</b>
     * </p>
     *
     * @param conditionBaseValue
     *            Condition Basis
     */
    public void setConditionBaseValue( @Nullable final BigDecimal conditionBaseValue )
    {
        rememberChangedField("ConditionBaseValue", this.conditionBaseValue);
        this.conditionBaseValue = conditionBaseValue;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Amount or Percentage
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Currency Key
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit in the Document
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @param conditionToBaseQtyNmrtr
     *            Numerator for Converting to Base UoM
     */
    public void setConditionToBaseQtyNmrtr( @Nullable final BigDecimal conditionToBaseQtyNmrtr )
    {
        rememberChangedField("ConditionToBaseQtyNmrtr", this.conditionToBaseQtyNmrtr);
        this.conditionToBaseQtyNmrtr = conditionToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @param conditionToBaseQtyDnmntr
     *            Denominator for Converting to Base UoM
     */
    public void setConditionToBaseQtyDnmntr( @Nullable final BigDecimal conditionToBaseQtyDnmntr )
    {
        rememberChangedField("ConditionToBaseQtyDnmntr", this.conditionToBaseQtyDnmntr);
        this.conditionToBaseQtyDnmntr = conditionToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     *
     * @param conditionCategory
     *            Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    public void setConditionCategory( @Nullable final String conditionCategory )
    {
        rememberChangedField("ConditionCategory", this.conditionCategory);
        this.conditionCategory = conditionCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     *
     * @param conditionIsForStatistics
     *            Condition is used for statistics
     */
    public void setConditionIsForStatistics( @Nullable final Boolean conditionIsForStatistics )
    {
        rememberChangedField("ConditionIsForStatistics", this.conditionIsForStatistics);
        this.conditionIsForStatistics = conditionIsForStatistics;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     *
     * @param isRelevantForAccrual
     *            Condition is Relevant for Accrual (e.g. Freight)
     */
    public void setIsRelevantForAccrual( @Nullable final Boolean isRelevantForAccrual )
    {
        rememberChangedField("IsRelevantForAccrual", this.isRelevantForAccrual);
        this.isRelevantForAccrual = isRelevantForAccrual;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForInvoiceList</b>
     * </p>
     *
     * @param cndnIsRelevantForInvoiceList
     *            Condition for Invoice List
     */
    public void setCndnIsRelevantForInvoiceList( @Nullable final String cndnIsRelevantForInvoiceList )
    {
        rememberChangedField("CndnIsRelevantForInvoiceList", this.cndnIsRelevantForInvoiceList);
        this.cndnIsRelevantForInvoiceList = cndnIsRelevantForInvoiceList;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionOrigin</b>
     * </p>
     *
     * @param conditionOrigin
     *            Origin of the Condition
     */
    public void setConditionOrigin( @Nullable final String conditionOrigin )
    {
        rememberChangedField("ConditionOrigin", this.conditionOrigin);
        this.conditionOrigin = conditionOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     *
     * @param isGroupCondition
     *            Group Condition
     */
    public void setIsGroupCondition( @Nullable final String isGroupCondition )
    {
        rememberChangedField("IsGroupCondition", this.isGroupCondition);
        this.isGroupCondition = isGroupCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccessNumberOfAccessSequence</b>
     * </p>
     *
     * @param accessNumberOfAccessSequence
     *            Access sequence - Access number
     */
    public void setAccessNumberOfAccessSequence( @Nullable final String accessNumberOfAccessSequence )
    {
        rememberChangedField("AccessNumberOfAccessSequence", this.accessNumberOfAccessSequence);
        this.accessNumberOfAccessSequence = accessNumberOfAccessSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential Number of the Condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     *
     * @param withholdingTaxCode
     *            Withholding tax code
     */
    public void setWithholdingTaxCode( @Nullable final String withholdingTaxCode )
    {
        rememberChangedField("WithholdingTaxCode", this.withholdingTaxCode);
        this.withholdingTaxCode = withholdingTaxCode;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnRoundingOffDiffAmount</b>
     * </p>
     *
     * @param cndnRoundingOffDiffAmount
     *            Rounding-Off Difference of the Condition
     */
    public void setCndnRoundingOffDiffAmount( @Nullable final BigDecimal cndnRoundingOffDiffAmount )
    {
        rememberChangedField("CndnRoundingOffDiffAmount", this.cndnRoundingOffDiffAmount);
        this.cndnRoundingOffDiffAmount = cndnRoundingOffDiffAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmount</b>
     * </p>
     *
     * @param conditionAmount
     *            Condition Value
     */
    public void setConditionAmount( @Nullable final BigDecimal conditionAmount )
    {
        rememberChangedField("ConditionAmount", this.conditionAmount);
        this.conditionAmount = conditionAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionControl</b>
     * </p>
     *
     * @param conditionControl
     *            Condition Control
     */
    public void setConditionControl( @Nullable final String conditionControl )
    {
        rememberChangedField("ConditionControl", this.conditionControl);
        this.conditionControl = conditionControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @param conditionInactiveReason
     *            Condition is Inactive
     */
    public void setConditionInactiveReason( @Nullable final String conditionInactiveReason )
    {
        rememberChangedField("ConditionInactiveReason", this.conditionInactiveReason);
        this.conditionInactiveReason = conditionInactiveReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     *
     * @param conditionClass
     *            Condition Class
     */
    public void setConditionClass( @Nullable final String conditionClass )
    {
        rememberChangedField("ConditionClass", this.conditionClass);
        this.conditionClass = conditionClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedureCounterForHeader</b>
     * </p>
     *
     * @param prcgProcedureCounterForHeader
     *            Condition Counter (Header)
     */
    public void setPrcgProcedureCounterForHeader( @Nullable final String prcgProcedureCounterForHeader )
    {
        rememberChangedField("PrcgProcedureCounterForHeader", this.prcgProcedureCounterForHeader);
        this.prcgProcedureCounterForHeader = prcgProcedureCounterForHeader;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FactorForConditionBasisValue</b>
     * </p>
     *
     * @param factorForConditionBasisValue
     *            Factor for Condition Base Value
     */
    public void setFactorForConditionBasisValue( @Nullable final Double factorForConditionBasisValue )
    {
        rememberChangedField("FactorForConditionBasisValue", this.factorForConditionBasisValue);
        this.factorForConditionBasisValue = factorForConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StructureCondition</b>
     * </p>
     *
     * @param structureCondition
     *            Structure Condition
     */
    public void setStructureCondition( @Nullable final String structureCondition )
    {
        rememberChangedField("StructureCondition", this.structureCondition);
        this.structureCondition = structureCondition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PeriodFactorForCndnBasisValue</b>
     * </p>
     *
     * @param periodFactorForCndnBasisValue
     *            Factor for Condition Basis (Period)
     */
    public void setPeriodFactorForCndnBasisValue( @Nullable final Double periodFactorForCndnBasisValue )
    {
        rememberChangedField("PeriodFactorForCndnBasisValue", this.periodFactorForCndnBasisValue);
        this.periodFactorForCndnBasisValue = periodFactorForCndnBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @param pricingScaleBasis
     *            Scale Basis Indicator
     */
    public void setPricingScaleBasis( @Nullable final String pricingScaleBasis )
    {
        rememberChangedField("PricingScaleBasis", this.pricingScaleBasis);
        this.pricingScaleBasis = pricingScaleBasis;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisValue</b>
     * </p>
     *
     * @param conditionScaleBasisValue
     *            Scale Base Value
     */
    public void setConditionScaleBasisValue( @Nullable final BigDecimal conditionScaleBasisValue )
    {
        rememberChangedField("ConditionScaleBasisValue", this.conditionScaleBasisValue);
        this.conditionScaleBasisValue = conditionScaleBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnit</b>
     * </p>
     *
     * @param conditionScaleBasisUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleBasisUnit( @Nullable final String conditionScaleBasisUnit )
    {
        rememberChangedField("ConditionScaleBasisUnit", this.conditionScaleBasisUnit);
        this.conditionScaleBasisUnit = conditionScaleBasisUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisCurrency</b>
     * </p>
     *
     * @param conditionScaleBasisCurrency
     *            Scale Currency
     */
    public void setConditionScaleBasisCurrency( @Nullable final String conditionScaleBasisCurrency )
    {
        rememberChangedField("ConditionScaleBasisCurrency", this.conditionScaleBasisCurrency);
        this.conditionScaleBasisCurrency = conditionScaleBasisCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAlternativeCurrency</b>
     * </p>
     *
     * @param conditionAlternativeCurrency
     *            Condition Currency (for Cumulation Fields)
     */
    public void setConditionAlternativeCurrency( @Nullable final String conditionAlternativeCurrency )
    {
        rememberChangedField("ConditionAlternativeCurrency", this.conditionAlternativeCurrency);
        this.conditionAlternativeCurrency = conditionAlternativeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmountInLocalCrcy</b>
     * </p>
     *
     * @param conditionAmountInLocalCrcy
     *            Condition Value
     */
    public void setConditionAmountInLocalCrcy( @Nullable final BigDecimal conditionAmountInLocalCrcy )
    {
        rememberChangedField("ConditionAmountInLocalCrcy", this.conditionAmountInLocalCrcy);
        this.conditionAmountInLocalCrcy = conditionAmountInLocalCrcy;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForIntcoBilling</b>
     * </p>
     *
     * @param cndnIsRelevantForIntcoBilling
     *            Condition for Intercompany Billing
     */
    public void setCndnIsRelevantForIntcoBilling( @Nullable final Boolean cndnIsRelevantForIntcoBilling )
    {
        rememberChangedField("CndnIsRelevantForIntcoBilling", this.cndnIsRelevantForIntcoBilling);
        this.cndnIsRelevantForIntcoBilling = cndnIsRelevantForIntcoBilling;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyChanged</b>
     * </p>
     *
     * @param conditionIsManuallyChanged
     *            Condition Changed Manually
     */
    public void setConditionIsManuallyChanged( @Nullable final Boolean conditionIsManuallyChanged )
    {
        rememberChangedField("ConditionIsManuallyChanged", this.conditionIsManuallyChanged);
        this.conditionIsManuallyChanged = conditionIsManuallyChanged;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>CumulatedConditionBasisValue</b>
     * </p>
     *
     * @param cumulatedConditionBasisValue
     *            Condition Basis
     */
    public void setCumulatedConditionBasisValue( @Nullable final BigDecimal cumulatedConditionBasisValue )
    {
        rememberChangedField("CumulatedConditionBasisValue", this.cumulatedConditionBasisValue);
        this.cumulatedConditionBasisValue = cumulatedConditionBasisValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForConfiguration</b>
     * </p>
     *
     * @param conditionIsForConfiguration
     *            Condition Used for Variant Configuration
     */
    public void setConditionIsForConfiguration( @Nullable final Boolean conditionIsForConfiguration )
    {
        rememberChangedField("ConditionIsForConfiguration", this.conditionIsForConfiguration);
        this.conditionIsForConfiguration = conditionIsForConfiguration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     *
     * @param variantCondition
     *            Variant Condition Key
     */
    public void setVariantCondition( @Nullable final String variantCondition )
    {
        rememberChangedField("VariantCondition", this.variantCondition);
        this.variantCondition = variantCondition;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CreditMemoReqPrcgElmnt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CreditMemoRequest", getCreditMemoRequest());
        result.put("PricingProcedureStep", getPricingProcedureStep());
        result.put("PricingProcedureCounter", getPricingProcedureCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CreditMemoRequest", getCreditMemoRequest());
        values.put("PricingProcedureStep", getPricingProcedureStep());
        values.put("PricingProcedureCounter", getPricingProcedureCounter());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("PricingDateTime", getPricingDateTime());
        values.put("PriceConditionDeterminationDte", getPriceConditionDeterminationDte());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("ConditionBaseValue", getConditionBaseValue());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionToBaseQtyNmrtr", getConditionToBaseQtyNmrtr());
        values.put("ConditionToBaseQtyDnmntr", getConditionToBaseQtyDnmntr());
        values.put("ConditionCategory", getConditionCategory());
        values.put("ConditionIsForStatistics", getConditionIsForStatistics());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("IsRelevantForAccrual", getIsRelevantForAccrual());
        values.put("CndnIsRelevantForInvoiceList", getCndnIsRelevantForInvoiceList());
        values.put("ConditionOrigin", getConditionOrigin());
        values.put("IsGroupCondition", getIsGroupCondition());
        values.put("AccessNumberOfAccessSequence", getAccessNumberOfAccessSequence());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("TaxCode", getTaxCode());
        values.put("WithholdingTaxCode", getWithholdingTaxCode());
        values.put("CndnRoundingOffDiffAmount", getCndnRoundingOffDiffAmount());
        values.put("ConditionAmount", getConditionAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ConditionControl", getConditionControl());
        values.put("ConditionInactiveReason", getConditionInactiveReason());
        values.put("ConditionClass", getConditionClass());
        values.put("PrcgProcedureCounterForHeader", getPrcgProcedureCounterForHeader());
        values.put("FactorForConditionBasisValue", getFactorForConditionBasisValue());
        values.put("StructureCondition", getStructureCondition());
        values.put("PeriodFactorForCndnBasisValue", getPeriodFactorForCndnBasisValue());
        values.put("PricingScaleBasis", getPricingScaleBasis());
        values.put("ConditionScaleBasisValue", getConditionScaleBasisValue());
        values.put("ConditionScaleBasisUnit", getConditionScaleBasisUnit());
        values.put("ConditionScaleBasisCurrency", getConditionScaleBasisCurrency());
        values.put("ConditionAlternativeCurrency", getConditionAlternativeCurrency());
        values.put("ConditionAmountInLocalCrcy", getConditionAmountInLocalCrcy());
        values.put("CndnIsRelevantForIntcoBilling", getCndnIsRelevantForIntcoBilling());
        values.put("ConditionIsManuallyChanged", getConditionIsManuallyChanged());
        values.put("CumulatedConditionBasisValue", getCumulatedConditionBasisValue());
        values.put("ConditionIsForConfiguration", getConditionIsForConfiguration());
        values.put("VariantCondition", getVariantCondition());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CreditMemoRequest") ) {
                final Object value = values.remove("CreditMemoRequest");
                if( (value == null) || (!value.equals(getCreditMemoRequest())) ) {
                    setCreditMemoRequest(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureStep") ) {
                final Object value = values.remove("PricingProcedureStep");
                if( (value == null) || (!value.equals(getPricingProcedureStep())) ) {
                    setPricingProcedureStep(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureCounter") ) {
                final Object value = values.remove("PricingProcedureCounter");
                if( (value == null) || (!value.equals(getPricingProcedureCounter())) ) {
                    setPricingProcedureCounter(((String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("PricingDateTime") ) {
                final Object value = values.remove("PricingDateTime");
                if( (value == null) || (!value.equals(getPricingDateTime())) ) {
                    setPricingDateTime(((String) value));
                }
            }
            if( values.containsKey("PriceConditionDeterminationDte") ) {
                final Object value = values.remove("PriceConditionDeterminationDte");
                if( (value == null) || (!value.equals(getPriceConditionDeterminationDte())) ) {
                    setPriceConditionDeterminationDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((String) value));
                }
            }
            if( values.containsKey("ConditionBaseValue") ) {
                final Object value = values.remove("ConditionBaseValue");
                if( (value == null) || (!value.equals(getConditionBaseValue())) ) {
                    setConditionBaseValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyNmrtr") ) {
                final Object value = values.remove("ConditionToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyNmrtr())) ) {
                    setConditionToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyDnmntr") ) {
                final Object value = values.remove("ConditionToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyDnmntr())) ) {
                    setConditionToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCategory") ) {
                final Object value = values.remove("ConditionCategory");
                if( (value == null) || (!value.equals(getConditionCategory())) ) {
                    setConditionCategory(((String) value));
                }
            }
            if( values.containsKey("ConditionIsForStatistics") ) {
                final Object value = values.remove("ConditionIsForStatistics");
                if( (value == null) || (!value.equals(getConditionIsForStatistics())) ) {
                    setConditionIsForStatistics(((Boolean) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((String) value));
                }
            }
            if( values.containsKey("IsRelevantForAccrual") ) {
                final Object value = values.remove("IsRelevantForAccrual");
                if( (value == null) || (!value.equals(getIsRelevantForAccrual())) ) {
                    setIsRelevantForAccrual(((Boolean) value));
                }
            }
            if( values.containsKey("CndnIsRelevantForInvoiceList") ) {
                final Object value = values.remove("CndnIsRelevantForInvoiceList");
                if( (value == null) || (!value.equals(getCndnIsRelevantForInvoiceList())) ) {
                    setCndnIsRelevantForInvoiceList(((String) value));
                }
            }
            if( values.containsKey("ConditionOrigin") ) {
                final Object value = values.remove("ConditionOrigin");
                if( (value == null) || (!value.equals(getConditionOrigin())) ) {
                    setConditionOrigin(((String) value));
                }
            }
            if( values.containsKey("IsGroupCondition") ) {
                final Object value = values.remove("IsGroupCondition");
                if( (value == null) || (!value.equals(getIsGroupCondition())) ) {
                    setIsGroupCondition(((String) value));
                }
            }
            if( values.containsKey("AccessNumberOfAccessSequence") ) {
                final Object value = values.remove("AccessNumberOfAccessSequence");
                if( (value == null) || (!value.equals(getAccessNumberOfAccessSequence())) ) {
                    setAccessNumberOfAccessSequence(((String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("WithholdingTaxCode") ) {
                final Object value = values.remove("WithholdingTaxCode");
                if( (value == null) || (!value.equals(getWithholdingTaxCode())) ) {
                    setWithholdingTaxCode(((String) value));
                }
            }
            if( values.containsKey("CndnRoundingOffDiffAmount") ) {
                final Object value = values.remove("CndnRoundingOffDiffAmount");
                if( (value == null) || (!value.equals(getCndnRoundingOffDiffAmount())) ) {
                    setCndnRoundingOffDiffAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionAmount") ) {
                final Object value = values.remove("ConditionAmount");
                if( (value == null) || (!value.equals(getConditionAmount())) ) {
                    setConditionAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionControl") ) {
                final Object value = values.remove("ConditionControl");
                if( (value == null) || (!value.equals(getConditionControl())) ) {
                    setConditionControl(((String) value));
                }
            }
            if( values.containsKey("ConditionInactiveReason") ) {
                final Object value = values.remove("ConditionInactiveReason");
                if( (value == null) || (!value.equals(getConditionInactiveReason())) ) {
                    setConditionInactiveReason(((String) value));
                }
            }
            if( values.containsKey("ConditionClass") ) {
                final Object value = values.remove("ConditionClass");
                if( (value == null) || (!value.equals(getConditionClass())) ) {
                    setConditionClass(((String) value));
                }
            }
            if( values.containsKey("PrcgProcedureCounterForHeader") ) {
                final Object value = values.remove("PrcgProcedureCounterForHeader");
                if( (value == null) || (!value.equals(getPrcgProcedureCounterForHeader())) ) {
                    setPrcgProcedureCounterForHeader(((String) value));
                }
            }
            if( values.containsKey("FactorForConditionBasisValue") ) {
                final Object value = values.remove("FactorForConditionBasisValue");
                if( (value == null) || (!value.equals(getFactorForConditionBasisValue())) ) {
                    setFactorForConditionBasisValue(((Double) value));
                }
            }
            if( values.containsKey("StructureCondition") ) {
                final Object value = values.remove("StructureCondition");
                if( (value == null) || (!value.equals(getStructureCondition())) ) {
                    setStructureCondition(((String) value));
                }
            }
            if( values.containsKey("PeriodFactorForCndnBasisValue") ) {
                final Object value = values.remove("PeriodFactorForCndnBasisValue");
                if( (value == null) || (!value.equals(getPeriodFactorForCndnBasisValue())) ) {
                    setPeriodFactorForCndnBasisValue(((Double) value));
                }
            }
            if( values.containsKey("PricingScaleBasis") ) {
                final Object value = values.remove("PricingScaleBasis");
                if( (value == null) || (!value.equals(getPricingScaleBasis())) ) {
                    setPricingScaleBasis(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisValue") ) {
                final Object value = values.remove("ConditionScaleBasisValue");
                if( (value == null) || (!value.equals(getConditionScaleBasisValue())) ) {
                    setConditionScaleBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisUnit") ) {
                final Object value = values.remove("ConditionScaleBasisUnit");
                if( (value == null) || (!value.equals(getConditionScaleBasisUnit())) ) {
                    setConditionScaleBasisUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisCurrency") ) {
                final Object value = values.remove("ConditionScaleBasisCurrency");
                if( (value == null) || (!value.equals(getConditionScaleBasisCurrency())) ) {
                    setConditionScaleBasisCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionAlternativeCurrency") ) {
                final Object value = values.remove("ConditionAlternativeCurrency");
                if( (value == null) || (!value.equals(getConditionAlternativeCurrency())) ) {
                    setConditionAlternativeCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionAmountInLocalCrcy") ) {
                final Object value = values.remove("ConditionAmountInLocalCrcy");
                if( (value == null) || (!value.equals(getConditionAmountInLocalCrcy())) ) {
                    setConditionAmountInLocalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CndnIsRelevantForIntcoBilling") ) {
                final Object value = values.remove("CndnIsRelevantForIntcoBilling");
                if( (value == null) || (!value.equals(getCndnIsRelevantForIntcoBilling())) ) {
                    setCndnIsRelevantForIntcoBilling(((Boolean) value));
                }
            }
            if( values.containsKey("ConditionIsManuallyChanged") ) {
                final Object value = values.remove("ConditionIsManuallyChanged");
                if( (value == null) || (!value.equals(getConditionIsManuallyChanged())) ) {
                    setConditionIsManuallyChanged(((Boolean) value));
                }
            }
            if( values.containsKey("CumulatedConditionBasisValue") ) {
                final Object value = values.remove("CumulatedConditionBasisValue");
                if( (value == null) || (!value.equals(getCumulatedConditionBasisValue())) ) {
                    setCumulatedConditionBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionIsForConfiguration") ) {
                final Object value = values.remove("ConditionIsForConfiguration");
                if( (value == null) || (!value.equals(getConditionIsForConfiguration())) ) {
                    setConditionIsForConfiguration(((Boolean) value));
                }
            }
            if( values.containsKey("VariantCondition") ) {
                final Object value = values.remove("VariantCondition");
                if( (value == null) || (!value.equals(getVariantCondition())) ) {
                    setVariantCondition(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CreditMemoRequest") ) {
                final Object value = (values).remove("to_CreditMemoRequest");
                if( value instanceof Map ) {
                    if( toCreditMemoRequest == null ) {
                        toCreditMemoRequest = new CreditMemoRequest();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCreditMemoRequest.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CreditMemoReqPrcgElmntField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CreditMemoReqPrcgElmntField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CreditMemoReqPrcgElmntField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CreditMemoReqPrcgElmntField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCreditMemoRequest != null ) {
            (values).put("to_CreditMemoRequest", toCreditMemoRequest);
        }
        return values;
    }

    /**
     * Fetches the <b>CreditMemoRequest</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CreditMemoRequest</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CreditMemoRequest</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMemoRequest fetchCreditMemoRequest()
    {
        return fetchFieldAsSingle("to_CreditMemoRequest", CreditMemoRequest.class);
    }

    /**
     * Retrieval of associated <b>CreditMemoRequest</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CreditMemoRequest</b>.
     * <p>
     * If the navigation property <b>to_CreditMemoRequest</b> of a queried <b>CreditMemoReqPrcgElmnt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditMemoRequest</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMemoRequest getCreditMemoRequestOrFetch()
    {
        if( toCreditMemoRequest == null ) {
            toCreditMemoRequest = fetchCreditMemoRequest();
        }
        return toCreditMemoRequest;
    }

    /**
     * Retrieval of associated <b>CreditMemoRequest</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CreditMemoRequest</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMemoReqPrcgElmnt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CreditMemoRequest</b> is already loaded, the result will
     *         contain the <b>CreditMemoRequest</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CreditMemoRequest> getCreditMemoRequestIfPresent()
    {
        return Option.of(toCreditMemoRequest);
    }

    /**
     * Overwrites the associated <b>CreditMemoRequest</b> entity for the loaded navigation property
     * <b>to_CreditMemoRequest</b>.
     *
     * @param value
     *            New <b>CreditMemoRequest</b> entity.
     */
    public void setCreditMemoRequest( final CreditMemoRequest value )
    {
        toCreditMemoRequest = value;
    }

    /**
     * Helper class to allow for fluent creation of CreditMemoReqPrcgElmnt instances.
     *
     */
    public final static class CreditMemoReqPrcgElmntBuilder
    {

        private CreditMemoRequest toCreditMemoRequest;
        private String creditMemoRequest = null;

        private CreditMemoReqPrcgElmnt.CreditMemoReqPrcgElmntBuilder toCreditMemoRequest(
            final CreditMemoRequest value )
        {
            toCreditMemoRequest = value;
            return this;
        }

        /**
         * Navigation property <b>to_CreditMemoRequest</b> for <b>CreditMemoReqPrcgElmnt</b> to single
         * <b>CreditMemoRequest</b>.
         *
         * @param value
         *            The CreditMemoRequest to build this CreditMemoReqPrcgElmnt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMemoReqPrcgElmnt.CreditMemoReqPrcgElmntBuilder creditMemoRequest( final CreditMemoRequest value )
        {
            return toCreditMemoRequest(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CreditMemoRequest</b>
         * </p>
         *
         * @param value
         *            The creditMemoRequest to build this CreditMemoReqPrcgElmnt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMemoReqPrcgElmnt.CreditMemoReqPrcgElmntBuilder creditMemoRequest( final String value )
        {
            creditMemoRequest = value;
            return this;
        }

    }

}
