/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.CreditMemoReqSubsqntProcFlowSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow
 * CreditMemoReqSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CreditMemoReqSubsqntProcFlowByKeyFluentHelper
    extends
    FluentHelperByKey<CreditMemoReqSubsqntProcFlowByKeyFluentHelper, CreditMemoReqSubsqntProcFlow, CreditMemoReqSubsqntProcFlowSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow
     * CreditMemoReqSubsqntProcFlow} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CreditMemoReqSubsqntProcFlow}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CreditMemoReqSubsqntProcFlow}
     * @param creditMemoRequest
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subsequentDocument
     *            Subsequent Sales and Distribution Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public CreditMemoReqSubsqntProcFlowByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String creditMemoRequest,
        final String subsequentDocument )
    {
        super(servicePath, entityCollection);
        this.key.put("CreditMemoRequest", creditMemoRequest);
        this.key.put("SubsequentDocument", subsequentDocument);
    }

    @Override
    @Nonnull
    protected Class<CreditMemoReqSubsqntProcFlow> getEntityClass()
    {
        return CreditMemoReqSubsqntProcFlow.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
