/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.CreditMemoRequestItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.CreditMemoRequestItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.CreditMemoRequestItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.CreditMemoRequestItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Credit Memo Request Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CreditMemoRequestItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CreditMemoRequestItem extends VdmEntity<CreditMemoRequestItem>
{

    /**
     * Selector for all available fields of CreditMemoRequestItem.
     *
     */
    public final static CreditMemoRequestItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequest</b>
     * </p>
     *
     * @return Credit Memo Request
     */
    @Key
    @SerializedName( "CreditMemoRequest" )
    @JsonProperty( "CreditMemoRequest" )
    @Nullable
    @ODataField( odataName = "CreditMemoRequest" )
    private String creditMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>CreditMemoRequest</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> CREDIT_MEMO_REQUEST =
        new CreditMemoRequestItemField<String>("CreditMemoRequest");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequestItem</b>
     * </p>
     *
     * @return Credit Memo Request Item
     */
    @Key
    @SerializedName( "CreditMemoRequestItem" )
    @JsonProperty( "CreditMemoRequestItem" )
    @Nullable
    @ODataField( odataName = "CreditMemoRequestItem" )
    private String creditMemoRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>CreditMemoRequestItem</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> CREDIT_MEMO_REQUEST_ITEM =
        new CreditMemoRequestItemField<String>("CreditMemoRequestItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Level Item in Bill of Material Structures
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> HIGHER_LEVEL_ITEM =
        new CreditMemoRequestItemField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequestItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "CreditMemoRequestItemCategory" )
    @JsonProperty( "CreditMemoRequestItemCategory" )
    @Nullable
    @ODataField( odataName = "CreditMemoRequestItemCategory" )
    private String creditMemoRequestItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>CreditMemoRequestItemCategory</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> CREDIT_MEMO_REQUEST_ITEM_CATEGORY =
        new CreditMemoRequestItemField<String>("CreditMemoRequestItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequestItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "CreditMemoRequestItemText" )
    @JsonProperty( "CreditMemoRequestItemText" )
    @Nullable
    @ODataField( odataName = "CreditMemoRequestItemText" )
    private String creditMemoRequestItemText;
    /**
     * Use with available fluent helpers to apply the <b>CreditMemoRequestItemText</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> CREDIT_MEMO_REQUEST_ITEM_TEXT =
        new CreditMemoRequestItemField<String>("CreditMemoRequestItemText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new CreditMemoRequestItemField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> MATERIAL =
        new CreditMemoRequestItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> MATERIAL_BY_CUSTOMER =
        new CreditMemoRequestItemField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<LocalDateTime> PRICING_DATE =
        new CreditMemoRequestItemField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Requested Quantity
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<BigDecimal> REQUESTED_QUANTITY =
        new CreditMemoRequestItemField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @return Unit of the Requested Quantity
     */
    @SerializedName( "RequestedQuantityUnit" )
    @JsonProperty( "RequestedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityUnit" )
    private String requestedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityUnit</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> REQUESTED_QUANTITY_UNIT =
        new CreditMemoRequestItemField<String>("RequestedQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantitySAPUnit" )
    @JsonProperty( "RequestedQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantitySAPUnit" )
    private String requestedQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> REQUESTED_QUANTITY_SAP_UNIT =
        new CreditMemoRequestItemField<String>("RequestedQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantityISOUnit" )
    @JsonProperty( "RequestedQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityISOUnit" )
    private String requestedQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityISOUnit</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> REQUESTED_QUANTITY_ISO_UNIT =
        new CreditMemoRequestItemField<String>("RequestedQuantityISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight of the Item
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<BigDecimal> ITEM_GROSS_WEIGHT =
        new CreditMemoRequestItemField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight of the Item
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<BigDecimal> ITEM_NET_WEIGHT =
        new CreditMemoRequestItemField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> ITEM_WEIGHT_UNIT =
        new CreditMemoRequestItemField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightSAPUnit" )
    @JsonProperty( "ItemWeightSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightSAPUnit" )
    private String itemWeightSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightSAPUnit</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> ITEM_WEIGHT_SAP_UNIT =
        new CreditMemoRequestItemField<String>("ItemWeightSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightISOUnit" )
    @JsonProperty( "ItemWeightISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightISOUnit" )
    private String itemWeightISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightISOUnit</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> ITEM_WEIGHT_ISO_UNIT =
        new CreditMemoRequestItemField<String>("ItemWeightISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume of the item
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<BigDecimal> ITEM_VOLUME =
        new CreditMemoRequestItemField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> ITEM_VOLUME_UNIT =
        new CreditMemoRequestItemField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeSAPUnit" )
    @JsonProperty( "ItemVolumeSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeSAPUnit" )
    private String itemVolumeSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeSAPUnit</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> ITEM_VOLUME_SAP_UNIT =
        new CreditMemoRequestItemField<String>("ItemVolumeSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeISOUnit" )
    @JsonProperty( "ItemVolumeISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeISOUnit" )
    private String itemVolumeISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeISOUnit</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> ITEM_VOLUME_ISO_UNIT =
        new CreditMemoRequestItemField<String>("ItemVolumeISOUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> TRANSACTION_CURRENCY =
        new CreditMemoRequestItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of the Order Item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<BigDecimal> NET_AMOUNT =
        new CreditMemoRequestItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> MATERIAL_GROUP =
        new CreditMemoRequestItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @return Material Price Group
     */
    @SerializedName( "MaterialPricingGroup" )
    @JsonProperty( "MaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MaterialPricingGroup" )
    private String materialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPricingGroup</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> MATERIAL_PRICING_GROUP =
        new CreditMemoRequestItemField<String>("MaterialPricingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification1" )
    @JsonProperty( "ProductTaxClassification1" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification1" )
    private String productTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification1</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PRODUCT_TAX_CLASSIFICATION1 =
        new CreditMemoRequestItemField<String>("ProductTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification2" )
    @JsonProperty( "ProductTaxClassification2" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification2" )
    private String productTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification2</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PRODUCT_TAX_CLASSIFICATION2 =
        new CreditMemoRequestItemField<String>("ProductTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification3" )
    @JsonProperty( "ProductTaxClassification3" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification3" )
    private String productTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification3</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PRODUCT_TAX_CLASSIFICATION3 =
        new CreditMemoRequestItemField<String>("ProductTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification4" )
    @JsonProperty( "ProductTaxClassification4" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification4" )
    private String productTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification4</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PRODUCT_TAX_CLASSIFICATION4 =
        new CreditMemoRequestItemField<String>("ProductTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification5" )
    @JsonProperty( "ProductTaxClassification5" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification5" )
    private String productTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification5</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PRODUCT_TAX_CLASSIFICATION5 =
        new CreditMemoRequestItemField<String>("ProductTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification6" )
    @JsonProperty( "ProductTaxClassification6" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification6" )
    private String productTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification6</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PRODUCT_TAX_CLASSIFICATION6 =
        new CreditMemoRequestItemField<String>("ProductTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification7" )
    @JsonProperty( "ProductTaxClassification7" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification7" )
    private String productTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification7</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PRODUCT_TAX_CLASSIFICATION7 =
        new CreditMemoRequestItemField<String>("ProductTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification8" )
    @JsonProperty( "ProductTaxClassification8" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification8" )
    private String productTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification8</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PRODUCT_TAX_CLASSIFICATION8 =
        new CreditMemoRequestItemField<String>("ProductTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification9" )
    @JsonProperty( "ProductTaxClassification9" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification9" )
    private String productTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification9</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PRODUCT_TAX_CLASSIFICATION9 =
        new CreditMemoRequestItemField<String>("ProductTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MatlAccountAssignmentGroup</b>
     * </p>
     *
     * @return Account Assignment Group for Material
     */
    @SerializedName( "MatlAccountAssignmentGroup" )
    @JsonProperty( "MatlAccountAssignmentGroup" )
    @Nullable
    @ODataField( odataName = "MatlAccountAssignmentGroup" )
    private String matlAccountAssignmentGroup;
    /**
     * Use with available fluent helpers to apply the <b>MatlAccountAssignmentGroup</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> MATL_ACCOUNT_ASSIGNMENT_GROUP =
        new CreditMemoRequestItemField<String>("MatlAccountAssignmentGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> BATCH = new CreditMemoRequestItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant (Own or External)
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PLANT = new CreditMemoRequestItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> INCOTERMS_CLASSIFICATION =
        new CreditMemoRequestItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new CreditMemoRequestItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> INCOTERMS_LOCATION1 =
        new CreditMemoRequestItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> INCOTERMS_LOCATION2 =
        new CreditMemoRequestItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> CUSTOMER_PAYMENT_TERMS =
        new CreditMemoRequestItemField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block for Item
     */
    @SerializedName( "ItemBillingBlockReason" )
    @JsonProperty( "ItemBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "ItemBillingBlockReason" )
    private String itemBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>ItemBillingBlockReason</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> ITEM_BILLING_BLOCK_REASON =
        new CreditMemoRequestItemField<String>("ItemBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> SALES_DOCUMENT_RJCN_REASON =
        new CreditMemoRequestItemField<String>("SalesDocumentRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> WBS_ELEMENT =
        new CreditMemoRequestItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> PROFIT_CENTER =
        new CreditMemoRequestItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> REFERENCE_SD_DOCUMENT =
        new CreditMemoRequestItemField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @return Item Number of the Reference Item
     */
    @SerializedName( "ReferenceSDDocumentItem" )
    @JsonProperty( "ReferenceSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentItem" )
    private String referenceSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentItem</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> REFERENCE_SD_DOCUMENT_ITEM =
        new CreditMemoRequestItemField<String>("ReferenceSDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Item)
     */
    @SerializedName( "SDProcessStatus" )
    @JsonProperty( "SDProcessStatus" )
    @Nullable
    @ODataField( odataName = "SDProcessStatus" )
    private String sDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDProcessStatus</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> SD_PROCESS_STATUS =
        new CreditMemoRequestItemField<String>("SDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderRelatedBillingStatus</b>
     * </p>
     *
     * @return Order-Related Billing Status (Item)
     */
    @SerializedName( "OrderRelatedBillingStatus" )
    @JsonProperty( "OrderRelatedBillingStatus" )
    @Nullable
    @ODataField( odataName = "OrderRelatedBillingStatus" )
    private String orderRelatedBillingStatus;
    /**
     * Use with available fluent helpers to apply the <b>OrderRelatedBillingStatus</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<String> ORDER_RELATED_BILLING_STATUS =
        new CreditMemoRequestItemField<String>("OrderRelatedBillingStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @return Date on which services are rendered
     */
    @SerializedName( "ServicesRenderedDate" )
    @JsonProperty( "ServicesRenderedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicesRenderedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime servicesRenderedDate;
    /**
     * Use with available fluent helpers to apply the <b>ServicesRenderedDate</b> field to query operations.
     *
     */
    public final static CreditMemoRequestItemField<LocalDateTime> SERVICES_RENDERED_DATE =
        new CreditMemoRequestItemField<LocalDateTime>("ServicesRenderedDate");
    /**
     * Navigation property <b>to_CreditMemoRequest</b> for <b>CreditMemoRequestItem</b> to single
     * <b>CreditMemoRequest</b>.
     *
     */
    @SerializedName( "to_CreditMemoRequest" )
    @JsonProperty( "to_CreditMemoRequest" )
    @ODataField( odataName = "to_CreditMemoRequest" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CreditMemoRequest toCreditMemoRequest;
    /**
     * Navigation property <b>to_ItemSubsqntProcFlow</b> for <b>CreditMemoRequestItem</b> to multiple
     * <b>CrdMmReqItemSubsqntProcFlow</b>.
     *
     */
    @SerializedName( "to_ItemSubsqntProcFlow" )
    @JsonProperty( "to_ItemSubsqntProcFlow" )
    @ODataField( odataName = "to_ItemSubsqntProcFlow" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CrdMmReqItemSubsqntProcFlow> toItemSubsqntProcFlow;
    /**
     * Navigation property <b>to_Partner</b> for <b>CreditMemoRequestItem</b> to multiple
     * <b>CreditMemoReqItemPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CreditMemoReqItemPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>CreditMemoRequestItem</b> to multiple
     * <b>CreditMemoReqItemPrcgElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CreditMemoReqItemPrcgElmnt> toPricingElement;
    /**
     * Navigation property <b>to_Text</b> for <b>CreditMemoRequestItem</b> to multiple <b>CreditMemoReqItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CreditMemoReqItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_CreditMemoRequest</b> navigation property to query
     * operations.
     *
     */
    public final static CreditMemoRequestItemOneToOneLink<CreditMemoRequest> TO_CREDIT_MEMO_REQUEST =
        new CreditMemoRequestItemOneToOneLink<CreditMemoRequest>("to_CreditMemoRequest");
    /**
     * Use with available fluent helpers to apply the <b>to_ItemSubsqntProcFlow</b> navigation property to query
     * operations.
     *
     */
    public final static CreditMemoRequestItemLink<CrdMmReqItemSubsqntProcFlow> TO_ITEM_SUBSQNT_PROC_FLOW =
        new CreditMemoRequestItemLink<CrdMmReqItemSubsqntProcFlow>("to_ItemSubsqntProcFlow");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static CreditMemoRequestItemLink<CreditMemoReqItemPartner> TO_PARTNER =
        new CreditMemoRequestItemLink<CreditMemoReqItemPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static CreditMemoRequestItemLink<CreditMemoReqItemPrcgElmnt> TO_PRICING_ELEMENT =
        new CreditMemoRequestItemLink<CreditMemoReqItemPrcgElmnt>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static CreditMemoRequestItemLink<CreditMemoReqItemText> TO_TEXT =
        new CreditMemoRequestItemLink<CreditMemoReqItemText>("to_Text");

    @Nonnull
    @Override
    public Class<CreditMemoRequestItem> getType()
    {
        return CreditMemoRequestItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequest</b>
     * </p>
     *
     * @param creditMemoRequest
     *            Credit Memo Request
     */
    public void setCreditMemoRequest( @Nullable final String creditMemoRequest )
    {
        rememberChangedField("CreditMemoRequest", this.creditMemoRequest);
        this.creditMemoRequest = creditMemoRequest;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequestItem</b>
     * </p>
     *
     * @param creditMemoRequestItem
     *            Credit Memo Request Item
     */
    public void setCreditMemoRequestItem( @Nullable final String creditMemoRequestItem )
    {
        rememberChangedField("CreditMemoRequestItem", this.creditMemoRequestItem);
        this.creditMemoRequestItem = creditMemoRequestItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Level Item in Bill of Material Structures
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequestItemCategory</b>
     * </p>
     *
     * @param creditMemoRequestItemCategory
     *            Sales Document Item Category
     */
    public void setCreditMemoRequestItemCategory( @Nullable final String creditMemoRequestItemCategory )
    {
        rememberChangedField("CreditMemoRequestItemCategory", this.creditMemoRequestItemCategory);
        this.creditMemoRequestItemCategory = creditMemoRequestItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequestItemText</b>
     * </p>
     *
     * @param creditMemoRequestItemText
     *            Short Text for Sales Order Item
     */
    public void setCreditMemoRequestItemText( @Nullable final String creditMemoRequestItemText )
    {
        rememberChangedField("CreditMemoRequestItemText", this.creditMemoRequestItemText);
        this.creditMemoRequestItemText = creditMemoRequestItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Requested Quantity
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @param requestedQuantityUnit
     *            Unit of the Requested Quantity
     */
    public void setRequestedQuantityUnit( @Nullable final String requestedQuantityUnit )
    {
        rememberChangedField("RequestedQuantityUnit", this.requestedQuantityUnit);
        this.requestedQuantityUnit = requestedQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @param requestedQuantitySAPUnit
     *            SAP Unit Code for Requested Quantity
     */
    public void setRequestedQuantitySAPUnit( @Nullable final String requestedQuantitySAPUnit )
    {
        rememberChangedField("RequestedQuantitySAPUnit", this.requestedQuantitySAPUnit);
        this.requestedQuantitySAPUnit = requestedQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @param requestedQuantityISOUnit
     *            ISO Unit Code for Requested Quantity
     */
    public void setRequestedQuantityISOUnit( @Nullable final String requestedQuantityISOUnit )
    {
        rememberChangedField("RequestedQuantityISOUnit", this.requestedQuantityISOUnit);
        this.requestedQuantityISOUnit = requestedQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight of the Item
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight of the Item
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @param itemWeightSAPUnit
     *            SAP Unit Code for Item Weight
     */
    public void setItemWeightSAPUnit( @Nullable final String itemWeightSAPUnit )
    {
        rememberChangedField("ItemWeightSAPUnit", this.itemWeightSAPUnit);
        this.itemWeightSAPUnit = itemWeightSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @param itemWeightISOUnit
     *            ISO Unit Code for Item Weight
     */
    public void setItemWeightISOUnit( @Nullable final String itemWeightISOUnit )
    {
        rememberChangedField("ItemWeightISOUnit", this.itemWeightISOUnit);
        this.itemWeightISOUnit = itemWeightISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume of the item
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @param itemVolumeSAPUnit
     *            SAP Unit Code for Item Volume
     */
    public void setItemVolumeSAPUnit( @Nullable final String itemVolumeSAPUnit )
    {
        rememberChangedField("ItemVolumeSAPUnit", this.itemVolumeSAPUnit);
        this.itemVolumeSAPUnit = itemVolumeSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @param itemVolumeISOUnit
     *            ISO Unit Code for Item Volume
     */
    public void setItemVolumeISOUnit( @Nullable final String itemVolumeISOUnit )
    {
        rememberChangedField("ItemVolumeISOUnit", this.itemVolumeISOUnit);
        this.itemVolumeISOUnit = itemVolumeISOUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of the Order Item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @param materialPricingGroup
     *            Material Price Group
     */
    public void setMaterialPricingGroup( @Nullable final String materialPricingGroup )
    {
        rememberChangedField("MaterialPricingGroup", this.materialPricingGroup);
        this.materialPricingGroup = materialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @param productTaxClassification1
     *            Tax Classification for Material
     */
    public void setProductTaxClassification1( @Nullable final String productTaxClassification1 )
    {
        rememberChangedField("ProductTaxClassification1", this.productTaxClassification1);
        this.productTaxClassification1 = productTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @param productTaxClassification2
     *            Tax Classification for Material
     */
    public void setProductTaxClassification2( @Nullable final String productTaxClassification2 )
    {
        rememberChangedField("ProductTaxClassification2", this.productTaxClassification2);
        this.productTaxClassification2 = productTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @param productTaxClassification3
     *            Tax Classification for Material
     */
    public void setProductTaxClassification3( @Nullable final String productTaxClassification3 )
    {
        rememberChangedField("ProductTaxClassification3", this.productTaxClassification3);
        this.productTaxClassification3 = productTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @param productTaxClassification4
     *            Tax Classification for Material
     */
    public void setProductTaxClassification4( @Nullable final String productTaxClassification4 )
    {
        rememberChangedField("ProductTaxClassification4", this.productTaxClassification4);
        this.productTaxClassification4 = productTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @param productTaxClassification5
     *            Tax Classification for Material
     */
    public void setProductTaxClassification5( @Nullable final String productTaxClassification5 )
    {
        rememberChangedField("ProductTaxClassification5", this.productTaxClassification5);
        this.productTaxClassification5 = productTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @param productTaxClassification6
     *            Tax Classification for Material
     */
    public void setProductTaxClassification6( @Nullable final String productTaxClassification6 )
    {
        rememberChangedField("ProductTaxClassification6", this.productTaxClassification6);
        this.productTaxClassification6 = productTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @param productTaxClassification7
     *            Tax Classification for Material
     */
    public void setProductTaxClassification7( @Nullable final String productTaxClassification7 )
    {
        rememberChangedField("ProductTaxClassification7", this.productTaxClassification7);
        this.productTaxClassification7 = productTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @param productTaxClassification8
     *            Tax Classification for Material
     */
    public void setProductTaxClassification8( @Nullable final String productTaxClassification8 )
    {
        rememberChangedField("ProductTaxClassification8", this.productTaxClassification8);
        this.productTaxClassification8 = productTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @param productTaxClassification9
     *            Tax Classification for Material
     */
    public void setProductTaxClassification9( @Nullable final String productTaxClassification9 )
    {
        rememberChangedField("ProductTaxClassification9", this.productTaxClassification9);
        this.productTaxClassification9 = productTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MatlAccountAssignmentGroup</b>
     * </p>
     *
     * @param matlAccountAssignmentGroup
     *            Account Assignment Group for Material
     */
    public void setMatlAccountAssignmentGroup( @Nullable final String matlAccountAssignmentGroup )
    {
        rememberChangedField("MatlAccountAssignmentGroup", this.matlAccountAssignmentGroup);
        this.matlAccountAssignmentGroup = matlAccountAssignmentGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant (Own or External)
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @param itemBillingBlockReason
     *            Billing Block for Item
     */
    public void setItemBillingBlockReason( @Nullable final String itemBillingBlockReason )
    {
        rememberChangedField("ItemBillingBlockReason", this.itemBillingBlockReason);
        this.itemBillingBlockReason = itemBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @param referenceSDDocumentItem
     *            Item Number of the Reference Item
     */
    public void setReferenceSDDocumentItem( @Nullable final String referenceSDDocumentItem )
    {
        rememberChangedField("ReferenceSDDocumentItem", this.referenceSDDocumentItem);
        this.referenceSDDocumentItem = referenceSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @param sDProcessStatus
     *            Overall Processing Status (Item)
     */
    public void setSDProcessStatus( @Nullable final String sDProcessStatus )
    {
        rememberChangedField("SDProcessStatus", this.sDProcessStatus);
        this.sDProcessStatus = sDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderRelatedBillingStatus</b>
     * </p>
     *
     * @param orderRelatedBillingStatus
     *            Order-Related Billing Status (Item)
     */
    public void setOrderRelatedBillingStatus( @Nullable final String orderRelatedBillingStatus )
    {
        rememberChangedField("OrderRelatedBillingStatus", this.orderRelatedBillingStatus);
        this.orderRelatedBillingStatus = orderRelatedBillingStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @param servicesRenderedDate
     *            Date on which services are rendered
     */
    public void setServicesRenderedDate( @Nullable final LocalDateTime servicesRenderedDate )
    {
        rememberChangedField("ServicesRenderedDate", this.servicesRenderedDate);
        this.servicesRenderedDate = servicesRenderedDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CreditMemoRequestItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CreditMemoRequest", getCreditMemoRequest());
        result.put("CreditMemoRequestItem", getCreditMemoRequestItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CreditMemoRequest", getCreditMemoRequest());
        values.put("CreditMemoRequestItem", getCreditMemoRequestItem());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("CreditMemoRequestItemCategory", getCreditMemoRequestItemCategory());
        values.put("CreditMemoRequestItemText", getCreditMemoRequestItemText());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("PricingDate", getPricingDate());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("RequestedQuantityUnit", getRequestedQuantityUnit());
        values.put("RequestedQuantitySAPUnit", getRequestedQuantitySAPUnit());
        values.put("RequestedQuantityISOUnit", getRequestedQuantityISOUnit());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemWeightSAPUnit", getItemWeightSAPUnit());
        values.put("ItemWeightISOUnit", getItemWeightISOUnit());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("ItemVolumeSAPUnit", getItemVolumeSAPUnit());
        values.put("ItemVolumeISOUnit", getItemVolumeISOUnit());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("NetAmount", getNetAmount());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialPricingGroup", getMaterialPricingGroup());
        values.put("ProductTaxClassification1", getProductTaxClassification1());
        values.put("ProductTaxClassification2", getProductTaxClassification2());
        values.put("ProductTaxClassification3", getProductTaxClassification3());
        values.put("ProductTaxClassification4", getProductTaxClassification4());
        values.put("ProductTaxClassification5", getProductTaxClassification5());
        values.put("ProductTaxClassification6", getProductTaxClassification6());
        values.put("ProductTaxClassification7", getProductTaxClassification7());
        values.put("ProductTaxClassification8", getProductTaxClassification8());
        values.put("ProductTaxClassification9", getProductTaxClassification9());
        values.put("MatlAccountAssignmentGroup", getMatlAccountAssignmentGroup());
        values.put("Batch", getBatch());
        values.put("Plant", getPlant());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("ItemBillingBlockReason", getItemBillingBlockReason());
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        values.put("WBSElement", getWBSElement());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentItem", getReferenceSDDocumentItem());
        values.put("SDProcessStatus", getSDProcessStatus());
        values.put("OrderRelatedBillingStatus", getOrderRelatedBillingStatus());
        values.put("ServicesRenderedDate", getServicesRenderedDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CreditMemoRequest") ) {
                final Object value = values.remove("CreditMemoRequest");
                if( (value == null) || (!value.equals(getCreditMemoRequest())) ) {
                    setCreditMemoRequest(((String) value));
                }
            }
            if( values.containsKey("CreditMemoRequestItem") ) {
                final Object value = values.remove("CreditMemoRequestItem");
                if( (value == null) || (!value.equals(getCreditMemoRequestItem())) ) {
                    setCreditMemoRequestItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("CreditMemoRequestItemCategory") ) {
                final Object value = values.remove("CreditMemoRequestItemCategory");
                if( (value == null) || (!value.equals(getCreditMemoRequestItemCategory())) ) {
                    setCreditMemoRequestItemCategory(((String) value));
                }
            }
            if( values.containsKey("CreditMemoRequestItemText") ) {
                final Object value = values.remove("CreditMemoRequestItemText");
                if( (value == null) || (!value.equals(getCreditMemoRequestItemText())) ) {
                    setCreditMemoRequestItemText(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantityUnit") ) {
                final Object value = values.remove("RequestedQuantityUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityUnit())) ) {
                    setRequestedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantitySAPUnit") ) {
                final Object value = values.remove("RequestedQuantitySAPUnit");
                if( (value == null) || (!value.equals(getRequestedQuantitySAPUnit())) ) {
                    setRequestedQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantityISOUnit") ) {
                final Object value = values.remove("RequestedQuantityISOUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityISOUnit())) ) {
                    setRequestedQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightSAPUnit") ) {
                final Object value = values.remove("ItemWeightSAPUnit");
                if( (value == null) || (!value.equals(getItemWeightSAPUnit())) ) {
                    setItemWeightSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightISOUnit") ) {
                final Object value = values.remove("ItemWeightISOUnit");
                if( (value == null) || (!value.equals(getItemWeightISOUnit())) ) {
                    setItemWeightISOUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeSAPUnit") ) {
                final Object value = values.remove("ItemVolumeSAPUnit");
                if( (value == null) || (!value.equals(getItemVolumeSAPUnit())) ) {
                    setItemVolumeSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeISOUnit") ) {
                final Object value = values.remove("ItemVolumeISOUnit");
                if( (value == null) || (!value.equals(getItemVolumeISOUnit())) ) {
                    setItemVolumeISOUnit(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialPricingGroup") ) {
                final Object value = values.remove("MaterialPricingGroup");
                if( (value == null) || (!value.equals(getMaterialPricingGroup())) ) {
                    setMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification1") ) {
                final Object value = values.remove("ProductTaxClassification1");
                if( (value == null) || (!value.equals(getProductTaxClassification1())) ) {
                    setProductTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification2") ) {
                final Object value = values.remove("ProductTaxClassification2");
                if( (value == null) || (!value.equals(getProductTaxClassification2())) ) {
                    setProductTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification3") ) {
                final Object value = values.remove("ProductTaxClassification3");
                if( (value == null) || (!value.equals(getProductTaxClassification3())) ) {
                    setProductTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification4") ) {
                final Object value = values.remove("ProductTaxClassification4");
                if( (value == null) || (!value.equals(getProductTaxClassification4())) ) {
                    setProductTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification5") ) {
                final Object value = values.remove("ProductTaxClassification5");
                if( (value == null) || (!value.equals(getProductTaxClassification5())) ) {
                    setProductTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification6") ) {
                final Object value = values.remove("ProductTaxClassification6");
                if( (value == null) || (!value.equals(getProductTaxClassification6())) ) {
                    setProductTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification7") ) {
                final Object value = values.remove("ProductTaxClassification7");
                if( (value == null) || (!value.equals(getProductTaxClassification7())) ) {
                    setProductTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification8") ) {
                final Object value = values.remove("ProductTaxClassification8");
                if( (value == null) || (!value.equals(getProductTaxClassification8())) ) {
                    setProductTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification9") ) {
                final Object value = values.remove("ProductTaxClassification9");
                if( (value == null) || (!value.equals(getProductTaxClassification9())) ) {
                    setProductTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("MatlAccountAssignmentGroup") ) {
                final Object value = values.remove("MatlAccountAssignmentGroup");
                if( (value == null) || (!value.equals(getMatlAccountAssignmentGroup())) ) {
                    setMatlAccountAssignmentGroup(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("ItemBillingBlockReason") ) {
                final Object value = values.remove("ItemBillingBlockReason");
                if( (value == null) || (!value.equals(getItemBillingBlockReason())) ) {
                    setItemBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentItem") ) {
                final Object value = values.remove("ReferenceSDDocumentItem");
                if( (value == null) || (!value.equals(getReferenceSDDocumentItem())) ) {
                    setReferenceSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SDProcessStatus") ) {
                final Object value = values.remove("SDProcessStatus");
                if( (value == null) || (!value.equals(getSDProcessStatus())) ) {
                    setSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("OrderRelatedBillingStatus") ) {
                final Object value = values.remove("OrderRelatedBillingStatus");
                if( (value == null) || (!value.equals(getOrderRelatedBillingStatus())) ) {
                    setOrderRelatedBillingStatus(((String) value));
                }
            }
            if( values.containsKey("ServicesRenderedDate") ) {
                final Object value = values.remove("ServicesRenderedDate");
                if( (value == null) || (!value.equals(getServicesRenderedDate())) ) {
                    setServicesRenderedDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CreditMemoRequest") ) {
                final Object value = (values).remove("to_CreditMemoRequest");
                if( value instanceof Map ) {
                    if( toCreditMemoRequest == null ) {
                        toCreditMemoRequest = new CreditMemoRequest();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCreditMemoRequest.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ItemSubsqntProcFlow") ) {
                final Object value = (values).remove("to_ItemSubsqntProcFlow");
                if( value instanceof Iterable ) {
                    if( toItemSubsqntProcFlow == null ) {
                        toItemSubsqntProcFlow = Lists.newArrayList();
                    } else {
                        toItemSubsqntProcFlow = Lists.newArrayList(toItemSubsqntProcFlow);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CrdMmReqItemSubsqntProcFlow entity;
                        if( toItemSubsqntProcFlow.size() > i ) {
                            entity = toItemSubsqntProcFlow.get(i);
                        } else {
                            entity = new CrdMmReqItemSubsqntProcFlow();
                            toItemSubsqntProcFlow.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CreditMemoReqItemPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new CreditMemoReqItemPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CreditMemoReqItemPrcgElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new CreditMemoReqItemPrcgElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CreditMemoReqItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new CreditMemoReqItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CreditMemoRequestItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CreditMemoRequestItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CreditMemoRequestItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CreditMemoRequestItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCreditMemoRequest != null ) {
            (values).put("to_CreditMemoRequest", toCreditMemoRequest);
        }
        if( toItemSubsqntProcFlow != null ) {
            (values).put("to_ItemSubsqntProcFlow", toItemSubsqntProcFlow);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>CreditMemoRequest</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CreditMemoRequest</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CreditMemoRequest</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMemoRequest fetchCreditMemoRequest()
    {
        return fetchFieldAsSingle("to_CreditMemoRequest", CreditMemoRequest.class);
    }

    /**
     * Retrieval of associated <b>CreditMemoRequest</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CreditMemoRequest</b>.
     * <p>
     * If the navigation property <b>to_CreditMemoRequest</b> of a queried <b>CreditMemoRequestItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditMemoRequest</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMemoRequest getCreditMemoRequestOrFetch()
    {
        if( toCreditMemoRequest == null ) {
            toCreditMemoRequest = fetchCreditMemoRequest();
        }
        return toCreditMemoRequest;
    }

    /**
     * Retrieval of associated <b>CreditMemoRequest</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CreditMemoRequest</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMemoRequestItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CreditMemoRequest</b> is already loaded, the result will
     *         contain the <b>CreditMemoRequest</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CreditMemoRequest> getCreditMemoRequestIfPresent()
    {
        return Option.of(toCreditMemoRequest);
    }

    /**
     * Overwrites the associated <b>CreditMemoRequest</b> entity for the loaded navigation property
     * <b>to_CreditMemoRequest</b>.
     *
     * @param value
     *            New <b>CreditMemoRequest</b> entity.
     */
    public void setCreditMemoRequest( final CreditMemoRequest value )
    {
        toCreditMemoRequest = value;
    }

    /**
     * Fetches the <b>CrdMmReqItemSubsqntProcFlow</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ItemSubsqntProcFlow</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CrdMmReqItemSubsqntProcFlow</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdMmReqItemSubsqntProcFlow> fetchItemSubsqntProcFlow()
    {
        return fetchFieldAsList("to_ItemSubsqntProcFlow", CrdMmReqItemSubsqntProcFlow.class);
    }

    /**
     * Retrieval of associated <b>CrdMmReqItemSubsqntProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ItemSubsqntProcFlow</b>.
     * <p>
     * If the navigation property <b>to_ItemSubsqntProcFlow</b> of a queried <b>CreditMemoRequestItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CrdMmReqItemSubsqntProcFlow</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdMmReqItemSubsqntProcFlow> getItemSubsqntProcFlowOrFetch()
    {
        if( toItemSubsqntProcFlow == null ) {
            toItemSubsqntProcFlow = fetchItemSubsqntProcFlow();
        }
        return toItemSubsqntProcFlow;
    }

    /**
     * Retrieval of associated <b>CrdMmReqItemSubsqntProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ItemSubsqntProcFlow</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMemoRequestItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ItemSubsqntProcFlow</b> is already loaded, the result
     *         will contain the <b>CrdMmReqItemSubsqntProcFlow</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CrdMmReqItemSubsqntProcFlow>> getItemSubsqntProcFlowIfPresent()
    {
        return Option.of(toItemSubsqntProcFlow);
    }

    /**
     * Overwrites the list of associated <b>CrdMmReqItemSubsqntProcFlow</b> entities for the loaded navigation property
     * <b>to_ItemSubsqntProcFlow</b>.
     * <p>
     * If the navigation property <b>to_ItemSubsqntProcFlow</b> of a queried <b>CreditMemoRequestItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CrdMmReqItemSubsqntProcFlow</b> entities.
     */
    public void setItemSubsqntProcFlow( @Nonnull final List<CrdMmReqItemSubsqntProcFlow> value )
    {
        if( toItemSubsqntProcFlow == null ) {
            toItemSubsqntProcFlow = Lists.newArrayList();
        }
        toItemSubsqntProcFlow.clear();
        toItemSubsqntProcFlow.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CrdMmReqItemSubsqntProcFlow</b> entities. This corresponds to the
     * OData navigation property <b>to_ItemSubsqntProcFlow</b>.
     * <p>
     * If the navigation property <b>to_ItemSubsqntProcFlow</b> of a queried <b>CreditMemoRequestItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CrdMmReqItemSubsqntProcFlow</b> entities.
     */
    public void addItemSubsqntProcFlow( CrdMmReqItemSubsqntProcFlow... entity )
    {
        if( toItemSubsqntProcFlow == null ) {
            toItemSubsqntProcFlow = Lists.newArrayList();
        }
        toItemSubsqntProcFlow.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CreditMemoReqItemPartner</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CreditMemoReqItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CreditMemoReqItemPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", CreditMemoReqItemPartner.class);
    }

    /**
     * Retrieval of associated <b>CreditMemoReqItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>CreditMemoRequestItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditMemoReqItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CreditMemoReqItemPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>CreditMemoReqItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMemoRequestItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>CreditMemoReqItemPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CreditMemoReqItemPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>CreditMemoReqItemPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>CreditMemoRequestItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CreditMemoReqItemPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<CreditMemoReqItemPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CreditMemoReqItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>CreditMemoRequestItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CreditMemoReqItemPartner</b> entities.
     */
    public void addPartner( CreditMemoReqItemPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CreditMemoReqItemPrcgElmnt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CreditMemoReqItemPrcgElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CreditMemoReqItemPrcgElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", CreditMemoReqItemPrcgElmnt.class);
    }

    /**
     * Retrieval of associated <b>CreditMemoReqItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>CreditMemoRequestItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditMemoReqItemPrcgElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CreditMemoReqItemPrcgElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>CreditMemoReqItemPrcgElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMemoRequestItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>CreditMemoReqItemPrcgElmnt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CreditMemoReqItemPrcgElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>CreditMemoReqItemPrcgElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>CreditMemoRequestItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CreditMemoReqItemPrcgElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<CreditMemoReqItemPrcgElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CreditMemoReqItemPrcgElmnt</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>CreditMemoRequestItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CreditMemoReqItemPrcgElmnt</b> entities.
     */
    public void addPricingElement( CreditMemoReqItemPrcgElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CreditMemoReqItemText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CreditMemoReqItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CreditMemoReqItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", CreditMemoReqItemText.class);
    }

    /**
     * Retrieval of associated <b>CreditMemoReqItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CreditMemoRequestItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditMemoReqItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CreditMemoReqItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>CreditMemoReqItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMemoRequestItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>CreditMemoReqItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CreditMemoReqItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>CreditMemoReqItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CreditMemoRequestItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CreditMemoReqItemText</b> entities.
     */
    public void setText( @Nonnull final List<CreditMemoReqItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CreditMemoReqItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CreditMemoRequestItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CreditMemoReqItemText</b> entities.
     */
    public void addText( CreditMemoReqItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CreditMemoRequestItem instances.
     *
     */
    public final static class CreditMemoRequestItemBuilder
    {

        private CreditMemoRequest toCreditMemoRequest;
        private String creditMemoRequest = null;
        private List<CrdMmReqItemSubsqntProcFlow> toItemSubsqntProcFlow = Lists.newArrayList();
        private List<CreditMemoReqItemPartner> toPartner = Lists.newArrayList();
        private List<CreditMemoReqItemPrcgElmnt> toPricingElement = Lists.newArrayList();
        private List<CreditMemoReqItemText> toText = Lists.newArrayList();

        private CreditMemoRequestItem.CreditMemoRequestItemBuilder toCreditMemoRequest( final CreditMemoRequest value )
        {
            toCreditMemoRequest = value;
            return this;
        }

        /**
         * Navigation property <b>to_CreditMemoRequest</b> for <b>CreditMemoRequestItem</b> to single
         * <b>CreditMemoRequest</b>.
         *
         * @param value
         *            The CreditMemoRequest to build this CreditMemoRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMemoRequestItem.CreditMemoRequestItemBuilder creditMemoRequest( final CreditMemoRequest value )
        {
            return toCreditMemoRequest(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CreditMemoRequest</b>
         * </p>
         *
         * @param value
         *            The creditMemoRequest to build this CreditMemoRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMemoRequestItem.CreditMemoRequestItemBuilder creditMemoRequest( final String value )
        {
            creditMemoRequest = value;
            return this;
        }

        private CreditMemoRequestItem.CreditMemoRequestItemBuilder toItemSubsqntProcFlow(
            final List<CrdMmReqItemSubsqntProcFlow> value )
        {
            toItemSubsqntProcFlow.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ItemSubsqntProcFlow</b> for <b>CreditMemoRequestItem</b> to multiple
         * <b>CrdMmReqItemSubsqntProcFlow</b>.
         *
         * @param value
         *            The CrdMmReqItemSubsqntProcFlows to build this CreditMemoRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMemoRequestItem.CreditMemoRequestItemBuilder itemSubsqntProcFlow(
            CrdMmReqItemSubsqntProcFlow... value )
        {
            return toItemSubsqntProcFlow(Lists.newArrayList(value));
        }

        private CreditMemoRequestItem.CreditMemoRequestItemBuilder toPartner(
            final List<CreditMemoReqItemPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>CreditMemoRequestItem</b> to multiple
         * <b>CreditMemoReqItemPartner</b>.
         *
         * @param value
         *            The CreditMemoReqItemPartners to build this CreditMemoRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMemoRequestItem.CreditMemoRequestItemBuilder partner( CreditMemoReqItemPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private CreditMemoRequestItem.CreditMemoRequestItemBuilder toPricingElement(
            final List<CreditMemoReqItemPrcgElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>CreditMemoRequestItem</b> to multiple
         * <b>CreditMemoReqItemPrcgElmnt</b>.
         *
         * @param value
         *            The CreditMemoReqItemPrcgElmnts to build this CreditMemoRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMemoRequestItem.CreditMemoRequestItemBuilder pricingElement( CreditMemoReqItemPrcgElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private CreditMemoRequestItem.CreditMemoRequestItemBuilder toText( final List<CreditMemoReqItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>CreditMemoRequestItem</b> to multiple <b>CreditMemoReqItemText</b>.
         *
         * @param value
         *            The CreditMemoReqItemTexts to build this CreditMemoRequestItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMemoRequestItem.CreditMemoRequestItemBuilder text( CreditMemoReqItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
