/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.CreditMemoRequestItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
 * CreditMemoRequestItem} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class CreditMemoRequestItemByKeyFluentHelper
    extends
    FluentHelperByKey<CreditMemoRequestItemByKeyFluentHelper, CreditMemoRequestItem, CreditMemoRequestItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     * CreditMemoRequestItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CreditMemoRequestItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CreditMemoRequestItem}
     * @param creditMemoRequest
     *            Credit Memo Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param creditMemoRequestItem
     *            Credit Memo Request Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public CreditMemoRequestItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String creditMemoRequest,
        final String creditMemoRequestItem )
    {
        super(servicePath, entityCollection);
        this.key.put("CreditMemoRequest", creditMemoRequest);
        this.key.put("CreditMemoRequestItem", creditMemoRequestItem);
    }

    @Override
    @Nonnull
    protected Class<CreditMemoRequestItem> getEntityClass()
    {
        return CreditMemoRequestItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
