/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.Customer_VHField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.Customer_VHSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Customer
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>I_Customer_VHType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Customer_VH extends VdmEntity<Customer_VH>
{

    /**
     * Selector for all available fields of Customer_VH.
     *
     */
    public final static Customer_VHSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> CUSTOMER = new Customer_VHField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "OrganizationBPName1" )
    @JsonProperty( "OrganizationBPName1" )
    @Nullable
    @ODataField( odataName = "OrganizationBPName1" )
    private String organizationBPName1;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationBPName1</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> ORGANIZATION_BP_NAME1 =
        new Customer_VHField<String>("OrganizationBPName1");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "OrganizationBPName2" )
    @JsonProperty( "OrganizationBPName2" )
    @Nullable
    @ODataField( odataName = "OrganizationBPName2" )
    private String organizationBPName2;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationBPName2</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> ORGANIZATION_BP_NAME2 =
        new Customer_VHField<String>("OrganizationBPName2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> COUNTRY = new Customer_VHField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> CITY_NAME = new Customer_VHField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street and House Number
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> STREET_NAME = new Customer_VHField<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> POSTAL_CODE = new Customer_VHField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @return Name of Customer
     */
    @SerializedName( "CustomerName" )
    @JsonProperty( "CustomerName" )
    @Nullable
    @ODataField( odataName = "CustomerName" )
    private String customerName;
    /**
     * Use with available fluent helpers to apply the <b>CustomerName</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> CUSTOMER_NAME = new Customer_VHField<String>("CustomerName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerAccountGroup</b>
     * </p>
     *
     * @return Customer Account Group
     */
    @SerializedName( "CustomerAccountGroup" )
    @JsonProperty( "CustomerAccountGroup" )
    @Nullable
    @ODataField( odataName = "CustomerAccountGroup" )
    private String customerAccountGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerAccountGroup</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> CUSTOMER_ACCOUNT_GROUP =
        new Customer_VHField<String>("CustomerAccountGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Authorization Group
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> AUTHORIZATION_GROUP =
        new Customer_VHField<String>("AuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @return Business Purpose Completed Flag
     */
    @SerializedName( "IsBusinessPurposeCompleted" )
    @JsonProperty( "IsBusinessPurposeCompleted" )
    @Nullable
    @ODataField( odataName = "IsBusinessPurposeCompleted" )
    private String isBusinessPurposeCompleted;
    /**
     * Use with available fluent helpers to apply the <b>IsBusinessPurposeCompleted</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> IS_BUSINESS_PURPOSE_COMPLETED =
        new Customer_VHField<String>("IsBusinessPurposeCompleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompetitor</b>
     * </p>
     *
     * @return Indicator: Competitor
     */
    @SerializedName( "IsCompetitor" )
    @JsonProperty( "IsCompetitor" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCompetitor" )
    private Boolean isCompetitor;
    /**
     * Use with available fluent helpers to apply the <b>IsCompetitor</b> field to query operations.
     *
     */
    public final static Customer_VHField<Boolean> IS_COMPETITOR = new Customer_VHField<Boolean>("IsCompetitor");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> BUSINESS_PARTNER = new Customer_VHField<String>("BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerType</b>
     * </p>
     *
     * @return Business Partner Type
     */
    @SerializedName( "BusinessPartnerType" )
    @JsonProperty( "BusinessPartnerType" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerType" )
    private String businessPartnerType;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerType</b> field to query operations.
     *
     */
    public final static Customer_VHField<String> BUSINESS_PARTNER_TYPE =
        new Customer_VHField<String>("BusinessPartnerType");

    @Nonnull
    @Override
    public Class<Customer_VH> getType()
    {
        return Customer_VH.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName1</b>
     * </p>
     *
     * @param organizationBPName1
     *            Name 1
     */
    public void setOrganizationBPName1( @Nullable final String organizationBPName1 )
    {
        rememberChangedField("OrganizationBPName1", this.organizationBPName1);
        this.organizationBPName1 = organizationBPName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName2</b>
     * </p>
     *
     * @param organizationBPName2
     *            Name 2
     */
    public void setOrganizationBPName2( @Nullable final String organizationBPName2 )
    {
        rememberChangedField("OrganizationBPName2", this.organizationBPName2);
        this.organizationBPName2 = organizationBPName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street and House Number
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @param customerName
     *            Name of Customer
     */
    public void setCustomerName( @Nullable final String customerName )
    {
        rememberChangedField("CustomerName", this.customerName);
        this.customerName = customerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerAccountGroup</b>
     * </p>
     *
     * @param customerAccountGroup
     *            Customer Account Group
     */
    public void setCustomerAccountGroup( @Nullable final String customerAccountGroup )
    {
        rememberChangedField("CustomerAccountGroup", this.customerAccountGroup);
        this.customerAccountGroup = customerAccountGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     *
     * @param isBusinessPurposeCompleted
     *            Business Purpose Completed Flag
     */
    public void setIsBusinessPurposeCompleted( @Nullable final String isBusinessPurposeCompleted )
    {
        rememberChangedField("IsBusinessPurposeCompleted", this.isBusinessPurposeCompleted);
        this.isBusinessPurposeCompleted = isBusinessPurposeCompleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompetitor</b>
     * </p>
     *
     * @param isCompetitor
     *            Indicator: Competitor
     */
    public void setIsCompetitor( @Nullable final Boolean isCompetitor )
    {
        rememberChangedField("IsCompetitor", this.isCompetitor);
        this.isCompetitor = isCompetitor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerType</b>
     * </p>
     *
     * @param businessPartnerType
     *            Business Partner Type
     */
    public void setBusinessPartnerType( @Nullable final String businessPartnerType )
    {
        rememberChangedField("BusinessPartnerType", this.businessPartnerType);
        this.businessPartnerType = businessPartnerType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "I_Customer_VH";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer", getCustomer());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer", getCustomer());
        values.put("OrganizationBPName1", getOrganizationBPName1());
        values.put("OrganizationBPName2", getOrganizationBPName2());
        values.put("Country", getCountry());
        values.put("CityName", getCityName());
        values.put("StreetName", getStreetName());
        values.put("PostalCode", getPostalCode());
        values.put("CustomerName", getCustomerName());
        values.put("CustomerAccountGroup", getCustomerAccountGroup());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("IsBusinessPurposeCompleted", getIsBusinessPurposeCompleted());
        values.put("IsCompetitor", getIsCompetitor());
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BusinessPartnerType", getBusinessPartnerType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("OrganizationBPName1") ) {
                final Object value = values.remove("OrganizationBPName1");
                if( (value == null) || (!value.equals(getOrganizationBPName1())) ) {
                    setOrganizationBPName1(((String) value));
                }
            }
            if( values.containsKey("OrganizationBPName2") ) {
                final Object value = values.remove("OrganizationBPName2");
                if( (value == null) || (!value.equals(getOrganizationBPName2())) ) {
                    setOrganizationBPName2(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("CustomerName") ) {
                final Object value = values.remove("CustomerName");
                if( (value == null) || (!value.equals(getCustomerName())) ) {
                    setCustomerName(((String) value));
                }
            }
            if( values.containsKey("CustomerAccountGroup") ) {
                final Object value = values.remove("CustomerAccountGroup");
                if( (value == null) || (!value.equals(getCustomerAccountGroup())) ) {
                    setCustomerAccountGroup(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("IsBusinessPurposeCompleted") ) {
                final Object value = values.remove("IsBusinessPurposeCompleted");
                if( (value == null) || (!value.equals(getIsBusinessPurposeCompleted())) ) {
                    setIsBusinessPurposeCompleted(((String) value));
                }
            }
            if( values.containsKey("IsCompetitor") ) {
                final Object value = values.remove("IsCompetitor");
                if( (value == null) || (!value.equals(getIsCompetitor())) ) {
                    setIsCompetitor(((Boolean) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerType") ) {
                final Object value = values.remove("BusinessPartnerType");
                if( (value == null) || (!value.equals(getBusinessPartnerType())) ) {
                    setBusinessPartnerType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> Customer_VHField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new Customer_VHField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> Customer_VHField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new Customer_VHField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService.DEFAULT_SERVICE_PATH);
    }

}
