/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.Customer_VHSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VH Customer_VH} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class Customer_VHByKeyFluentHelper
    extends
    FluentHelperByKey<Customer_VHByKeyFluentHelper, Customer_VH, Customer_VHSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VH Customer_VH} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code Customer_VH}
     * @param servicePath
     *            Service path to be used to fetch a single {@code Customer_VH}
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public Customer_VHByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String customer )
    {
        super(servicePath, entityCollection);
        this.key.put("Customer", customer);
    }

    @Override
    @Nonnull
    protected Class<Customer_VH> getEntityClass()
    {
        return Customer_VH.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
