/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.ProductStdVHField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.ProductStdVHSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product Value Help
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>I_ProductStdVHType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductStdVH extends VdmEntity<ProductStdVH>
{

    /**
     * Selector for all available fields of ProductStdVH.
     *
     */
    public final static ProductStdVHSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductStdVHField<String> PRODUCT = new ProductStdVHField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product_Text</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "Product_Text" )
    @JsonProperty( "Product_Text" )
    @Nullable
    @ODataField( odataName = "Product_Text" )
    private String product_Text;
    /**
     * Use with available fluent helpers to apply the <b>Product_Text</b> field to query operations.
     *
     */
    public final static ProductStdVHField<String> PRODUCT_TEXT = new ProductStdVHField<String>("Product_Text");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductExternalID</b>
     * </p>
     *
     * @return External Representation of Material Number
     */
    @SerializedName( "ProductExternalID" )
    @JsonProperty( "ProductExternalID" )
    @Nullable
    @ODataField( odataName = "ProductExternalID" )
    private String productExternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProductExternalID</b> field to query operations.
     *
     */
    public final static ProductStdVHField<String> PRODUCT_EXTERNAL_ID =
        new ProductStdVHField<String>("ProductExternalID");

    @Nonnull
    @Override
    public Class<ProductStdVH> getType()
    {
        return ProductStdVH.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product_Text</b>
     * </p>
     *
     * @param product_Text
     *            Product Description
     */
    public void setProduct_Text( @Nullable final String product_Text )
    {
        rememberChangedField("Product_Text", this.product_Text);
        this.product_Text = product_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductExternalID</b>
     * </p>
     *
     * @param productExternalID
     *            External Representation of Material Number
     */
    public void setProductExternalID( @Nullable final String productExternalID )
    {
        rememberChangedField("ProductExternalID", this.productExternalID);
        this.productExternalID = productExternalID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "I_ProductStdVH";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Product_Text", getProduct_Text());
        values.put("ProductExternalID", getProductExternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Product_Text") ) {
                final Object value = values.remove("Product_Text");
                if( (value == null) || (!value.equals(getProduct_Text())) ) {
                    setProduct_Text(((String) value));
                }
            }
            if( values.containsKey("ProductExternalID") ) {
                final Object value = values.remove("ProductExternalID");
                if( (value == null) || (!value.equals(getProductExternalID())) ) {
                    setProductExternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductStdVHField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductStdVHField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductStdVHField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductStdVHField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService.DEFAULT_SERVICE_PATH);
    }

}
