/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.SalesDealStdVHSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVH SalesDealStdVH} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class SalesDealStdVHByKeyFluentHelper
    extends
    FluentHelperByKey<SalesDealStdVHByKeyFluentHelper, SalesDealStdVH, SalesDealStdVHSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVH SalesDealStdVH}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesDealStdVH}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesDealStdVH}
     * @param salesDeal
     *            Agreement (various conditions grouped together)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public SalesDealStdVHByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesDeal )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesDeal", salesDeal);
    }

    @Override
    @Nonnull
    protected Class<SalesDealStdVH> getEntityClass()
    {
        return SalesDealStdVH.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
