/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService CreditMemoRequestService}.
 *
 */
public interface CreditMemoRequestServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CreditMemoRequestServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CreditMemoRequestServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     * CreditMemoReqItemPartner} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     *            CreditMemoReqItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        updateCreditMemoReqItemPartner( @Nonnull final CreditMemoReqItemPartner creditMemoReqItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     * CreditMemoReqItemPartner} entity in the S/4HANA system.
     *
     * @param creditMemoReqItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     *            CreditMemoReqItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        deleteCreditMemoReqItemPartner( @Nonnull final CreditMemoReqItemPartner creditMemoReqItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     * CreditMemoReqItemPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     *            CreditMemoReqItemPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        updateCreditMemoReqItemPrcgElmnt( @Nonnull final CreditMemoReqItemPrcgElmnt creditMemoReqItemPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     * CreditMemoReqItemPrcgElmnt} entity in the S/4HANA system.
     *
     * @param creditMemoReqItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     *            CreditMemoReqItemPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        deleteCreditMemoReqItemPrcgElmnt( @Nonnull final CreditMemoReqItemPrcgElmnt creditMemoReqItemPrcgElmnt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     * CreditMemoReqItemText} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     *            CreditMemoReqItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        updateCreditMemoReqItemText( @Nonnull final CreditMemoReqItemText creditMemoReqItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     * CreditMemoReqItemText} entity in the S/4HANA system.
     *
     * @param creditMemoReqItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     *            CreditMemoReqItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        deleteCreditMemoReqItemText( @Nonnull final CreditMemoReqItemText creditMemoReqItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     * CreditMemoReqPartner} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     *            CreditMemoReqPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        updateCreditMemoReqPartner( @Nonnull final CreditMemoReqPartner creditMemoReqPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     * CreditMemoReqPartner} entity in the S/4HANA system.
     *
     * @param creditMemoReqPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     *            CreditMemoReqPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        deleteCreditMemoReqPartner( @Nonnull final CreditMemoReqPartner creditMemoReqPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     * CreditMemoReqPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     *            CreditMemoReqPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        updateCreditMemoReqPrcgElmnt( @Nonnull final CreditMemoReqPrcgElmnt creditMemoReqPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     * CreditMemoReqPrcgElmnt} entity in the S/4HANA system.
     *
     * @param creditMemoReqPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     *            CreditMemoReqPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        deleteCreditMemoReqPrcgElmnt( @Nonnull final CreditMemoReqPrcgElmnt creditMemoReqPrcgElmnt );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     * CreditMemoReqText} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     *            CreditMemoReqText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        updateCreditMemoReqText( @Nonnull final CreditMemoReqText creditMemoReqText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText CreditMemoReqText}
     * entity in the S/4HANA system.
     *
     * @param creditMemoReqText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     *            CreditMemoReqText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        deleteCreditMemoReqText( @Nonnull final CreditMemoReqText creditMemoReqText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     * CreditMemoRequest} entity and save it to the S/4HANA system.
     *
     * @param creditMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *            CreditMemoRequest} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        createCreditMemoRequest( @Nonnull final CreditMemoRequest creditMemoRequest );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     * CreditMemoRequest} entity and save it to the S/4HANA system.
     *
     * @param creditMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *            CreditMemoRequest} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        updateCreditMemoRequest( @Nonnull final CreditMemoRequest creditMemoRequest );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest CreditMemoRequest}
     * entity in the S/4HANA system.
     *
     * @param creditMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *            CreditMemoRequest} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        deleteCreditMemoRequest( @Nonnull final CreditMemoRequest creditMemoRequest );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     * CreditMemoRequestItem} entity and save it to the S/4HANA system.
     *
     * @param creditMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *            CreditMemoRequestItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        createCreditMemoRequestItem( @Nonnull final CreditMemoRequestItem creditMemoRequestItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     * CreditMemoRequestItem} entity and save it to the S/4HANA system.
     *
     * @param creditMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *            CreditMemoRequestItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        updateCreditMemoRequestItem( @Nonnull final CreditMemoRequestItem creditMemoRequestItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     * CreditMemoRequestItem} entity in the S/4HANA system.
     *
     * @param creditMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *            CreditMemoRequestItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditMemoRequestServiceBatchChangeSet
        deleteCreditMemoRequestItem( @Nonnull final CreditMemoRequestItem creditMemoRequestItem );

}
