/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CreditMemoRequestServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService CreditMemoRequestService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCreditMemoRequestServiceBatch
    extends
    BatchFluentHelperBasic<CreditMemoRequestServiceBatch, CreditMemoRequestServiceBatchChangeSet>
    implements
    CreditMemoRequestServiceBatch
{

    @Nonnull
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCreditMemoRequestServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    public DefaultCreditMemoRequestServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCreditMemoRequestServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    public DefaultCreditMemoRequestServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCreditMemoRequestServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCreditMemoRequestServiceBatchChangeSet(this, service);
    }

}
