/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem;

/**
 * Implementation of the {@link CreditMemoRequestServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService CreditMemoRequestService}.
 *
 */
public class DefaultCreditMemoRequestServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CreditMemoRequestServiceBatch, CreditMemoRequestServiceBatchChangeSet>
    implements
    CreditMemoRequestServiceBatchChangeSet
{

    @Nonnull
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService service;

    DefaultCreditMemoRequestServiceBatchChangeSet(
        @Nonnull final DefaultCreditMemoRequestServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCreditMemoRequestServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet updateCreditMemoReqItemPartner(
        @Nonnull final CreditMemoReqItemPartner creditMemoReqItemPartner )
    {
        return addRequestUpdate(service::updateCreditMemoReqItemPartner, creditMemoReqItemPartner);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet deleteCreditMemoReqItemPartner(
        @Nonnull final CreditMemoReqItemPartner creditMemoReqItemPartner )
    {
        return addRequestDelete(service::deleteCreditMemoReqItemPartner, creditMemoReqItemPartner);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet updateCreditMemoReqItemPrcgElmnt(
        @Nonnull final CreditMemoReqItemPrcgElmnt creditMemoReqItemPrcgElmnt )
    {
        return addRequestUpdate(service::updateCreditMemoReqItemPrcgElmnt, creditMemoReqItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet deleteCreditMemoReqItemPrcgElmnt(
        @Nonnull final CreditMemoReqItemPrcgElmnt creditMemoReqItemPrcgElmnt )
    {
        return addRequestDelete(service::deleteCreditMemoReqItemPrcgElmnt, creditMemoReqItemPrcgElmnt);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet updateCreditMemoReqItemText(
        @Nonnull final CreditMemoReqItemText creditMemoReqItemText )
    {
        return addRequestUpdate(service::updateCreditMemoReqItemText, creditMemoReqItemText);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet deleteCreditMemoReqItemText(
        @Nonnull final CreditMemoReqItemText creditMemoReqItemText )
    {
        return addRequestDelete(service::deleteCreditMemoReqItemText, creditMemoReqItemText);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet updateCreditMemoReqPartner(
        @Nonnull final CreditMemoReqPartner creditMemoReqPartner )
    {
        return addRequestUpdate(service::updateCreditMemoReqPartner, creditMemoReqPartner);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet deleteCreditMemoReqPartner(
        @Nonnull final CreditMemoReqPartner creditMemoReqPartner )
    {
        return addRequestDelete(service::deleteCreditMemoReqPartner, creditMemoReqPartner);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet updateCreditMemoReqPrcgElmnt(
        @Nonnull final CreditMemoReqPrcgElmnt creditMemoReqPrcgElmnt )
    {
        return addRequestUpdate(service::updateCreditMemoReqPrcgElmnt, creditMemoReqPrcgElmnt);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet deleteCreditMemoReqPrcgElmnt(
        @Nonnull final CreditMemoReqPrcgElmnt creditMemoReqPrcgElmnt )
    {
        return addRequestDelete(service::deleteCreditMemoReqPrcgElmnt, creditMemoReqPrcgElmnt);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet updateCreditMemoReqText(
        @Nonnull final CreditMemoReqText creditMemoReqText )
    {
        return addRequestUpdate(service::updateCreditMemoReqText, creditMemoReqText);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet deleteCreditMemoReqText(
        @Nonnull final CreditMemoReqText creditMemoReqText )
    {
        return addRequestDelete(service::deleteCreditMemoReqText, creditMemoReqText);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet createCreditMemoRequest(
        @Nonnull final CreditMemoRequest creditMemoRequest )
    {
        return addRequestCreate(service::createCreditMemoRequest, creditMemoRequest);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet updateCreditMemoRequest(
        @Nonnull final CreditMemoRequest creditMemoRequest )
    {
        return addRequestUpdate(service::updateCreditMemoRequest, creditMemoRequest);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet deleteCreditMemoRequest(
        @Nonnull final CreditMemoRequest creditMemoRequest )
    {
        return addRequestDelete(service::deleteCreditMemoRequest, creditMemoRequest);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet createCreditMemoRequestItem(
        @Nonnull final CreditMemoRequestItem creditMemoRequestItem )
    {
        return addRequestCreate(service::createCreditMemoRequestItem, creditMemoRequestItem);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet updateCreditMemoRequestItem(
        @Nonnull final CreditMemoRequestItem creditMemoRequestItem )
    {
        return addRequestUpdate(service::updateCreditMemoRequestItem, creditMemoRequestItem);
    }

    @Nonnull
    @Override
    public CreditMemoRequestServiceBatchChangeSet deleteCreditMemoRequestItem(
        @Nonnull final CreditMemoRequestItem creditMemoRequestItem )
    {
        return addRequestDelete(service::deleteCreditMemoRequestItem, creditMemoRequestItem);
    }

}
