/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVH;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable.ControllingAreaStdVHSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVH
 * ControllingAreaStdVH} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ControllingAreaStdVHLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ControllingAreaStdVHLink<ObjectT>, ControllingAreaStdVH, ObjectT>
    implements
    ControllingAreaStdVHSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ControllingAreaStdVHLink( final String fieldName )
    {
        super(fieldName);
    }

    private ControllingAreaStdVHLink(
        final EntityLink<ControllingAreaStdVHLink<ObjectT>, ControllingAreaStdVH, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ControllingAreaStdVHLink<ObjectT> translateLinkType(
        final EntityLink<ControllingAreaStdVHLink<ObjectT>, ControllingAreaStdVH, ObjectT> link )
    {
        return new ControllingAreaStdVHLink<ObjectT>(link);
    }

}
