/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVH;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVH BusinessAreaStdVH}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.BusinessAreaStdVHField
 * BusinessAreaStdVHField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.BusinessAreaStdVHLink
 * BusinessAreaStdVHLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVH#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVH#BUSINESS_AREA_TEXT
 * BUSINESS_AREA_TEXT}</li>
 * </ul>
 *
 */
public interface BusinessAreaStdVHSelectable extends EntitySelectable<BusinessAreaStdVH>
{

}
