/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVH;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVH
 * ControllingObjectStdVH}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.ControllingObjectStdVHField
 * ControllingObjectStdVHField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.ControllingObjectStdVHLink
 * ControllingObjectStdVHLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVH#CONTROLLING_OBJECT
 * CONTROLLING_OBJECT}</li>
 * </ul>
 *
 */
public interface ControllingObjectStdVHSelectable extends EntitySelectable<ControllingObjectStdVH>
{

}
