/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow
 * CrdMmReqItemSubsqntProcFlow}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.CrdMmReqItemSubsqntProcFlowField
 * CrdMmReqItemSubsqntProcFlowField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.CrdMmReqItemSubsqntProcFlowLink
 * CrdMmReqItemSubsqntProcFlowLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#CREDIT_MEMO_REQUEST
 * CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#CREDIT_MEMO_REQUEST_ITEM
 * CREDIT_MEMO_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#DOC_RELATIONSHIP_UUID
 * DOC_RELATIONSHIP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#SUBSEQUENT_DOCUMENT
 * SUBSEQUENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#SUBSEQUENT_DOCUMENT_ITEM
 * SUBSEQUENT_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#SUBSEQUENT_DOCUMENT_CATEGORY
 * SUBSEQUENT_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#PROCESS_FLOW_LEVEL
 * PROCESS_FLOW_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#ACCOUNTING_TRANSFER_STATUS
 * ACCOUNTING_TRANSFER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#SD_PROCESS_STATUS
 * SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#RELATED_PROC_FLOW_DOC_STS_FIELD_NAME
 * RELATED_PROC_FLOW_DOC_STS_FIELD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#SUBSQNT_DOC_ITM_PRECDG_DOCUMENT
 * SUBSQNT_DOC_ITM_PRECDG_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#SUBSQNT_DOC_ITM_PRECDG_DOC_ITEM
 * SUBSQNT_DOC_ITM_PRECDG_DOC_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#SUBSQNT_DOC_ITM_PRECDG_DOC_CATEGORY
 * SUBSQNT_DOC_ITM_PRECDG_DOC_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#TO_CREDIT_MEMO_REQUEST
 * TO_CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow#TO_CREDIT_MEMO_REQUEST_ITEM
 * TO_CREDIT_MEMO_REQUEST_ITEM}</li>
 * </ul>
 *
 */
public interface CrdMmReqItemSubsqntProcFlowSelectable extends EntitySelectable<CrdMmReqItemSubsqntProcFlow>
{

}
