/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVH;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVH
 * CreditControlAreaStdVH}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.CreditControlAreaStdVHField
 * CreditControlAreaStdVHField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.CreditControlAreaStdVHLink
 * CreditControlAreaStdVHLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVH#CREDIT_CONTROL_AREA
 * CREDIT_CONTROL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVH#CREDIT_CONTROL_AREA_TEXT
 * CREDIT_CONTROL_AREA_TEXT}</li>
 * </ul>
 *
 */
public interface CreditControlAreaStdVHSelectable extends EntitySelectable<CreditControlAreaStdVH>
{

}
