/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
 * CreditMemoReqItemPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.CreditMemoReqItemPartnerField
 * CreditMemoReqItemPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.CreditMemoReqItemPartnerLink
 * CreditMemoReqItemPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner#CREDIT_MEMO_REQUEST
 * CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner#CREDIT_MEMO_REQUEST_ITEM
 * CREDIT_MEMO_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner#TO_CREDIT_MEMO_REQUEST
 * TO_CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner#TO_CREDIT_MEMO_REQUEST_ITEM
 * TO_CREDIT_MEMO_REQUEST_ITEM}</li>
 * </ul>
 *
 */
public interface CreditMemoReqItemPartnerSelectable extends EntitySelectable<CreditMemoReqItemPartner>
{

}
