/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
 * CreditMemoReqPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.CreditMemoReqPartnerField
 * CreditMemoReqPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.CreditMemoReqPartnerLink
 * CreditMemoReqPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner#CREDIT_MEMO_REQUEST
 * CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner#TO_CREDIT_MEMO_REQUEST
 * TO_CREDIT_MEMO_REQUEST}</li>
 * </ul>
 *
 */
public interface CreditMemoReqPartnerSelectable extends EntitySelectable<CreditMemoReqPartner>
{

}
