/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow
 * CreditMemoReqSubsqntProcFlow}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.CreditMemoReqSubsqntProcFlowField
 * CreditMemoReqSubsqntProcFlowField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.CreditMemoReqSubsqntProcFlowLink
 * CreditMemoReqSubsqntProcFlowLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#CREDIT_MEMO_REQUEST
 * CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#SUBSEQUENT_DOCUMENT
 * SUBSEQUENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#SUBSEQUENT_DOCUMENT_CATEGORY
 * SUBSEQUENT_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#PROCESS_FLOW_LEVEL
 * PROCESS_FLOW_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#OVERALL_BILLING_STATUS
 * OVERALL_BILLING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#OVERALL_SD_PROCESS_STATUS
 * OVERALL_SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#RELATED_PROC_FLOW_DOC_STS_FIELD_NAME
 * RELATED_PROC_FLOW_DOC_STS_FIELD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow#TO_CREDIT_MEMO_REQUEST
 * TO_CREDIT_MEMO_REQUEST}</li>
 * </ul>
 *
 */
public interface CreditMemoReqSubsqntProcFlowSelectable extends EntitySelectable<CreditMemoReqSubsqntProcFlow>
{

}
