/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest CreditMemoRequest}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.field.CreditMemoRequestField
 * CreditMemoRequestField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.link.CreditMemoRequestLink
 * CreditMemoRequestLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CREDIT_MEMO_REQUEST
 * CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CREDIT_MEMO_REQUEST_TYPE
 * CREDIT_MEMO_REQUEST_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#PURCHASE_ORDER_BY_CUSTOMER
 * PURCHASE_ORDER_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_PURCHASE_ORDER_TYPE
 * CUSTOMER_PURCHASE_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_PURCHASE_ORDER_DATE
 * CUSTOMER_PURCHASE_ORDER_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CREDIT_MEMO_REQUEST_DATE
 * CREDIT_MEMO_REQUEST_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#TOTAL_NET_AMOUNT
 * TOTAL_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#SD_DOCUMENT_REASON
 * SD_DOCUMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#PRICING_DATE
 * PRICING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_TAX_CLASSIFICATION1
 * CUSTOMER_TAX_CLASSIFICATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_TAX_CLASSIFICATION2
 * CUSTOMER_TAX_CLASSIFICATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_TAX_CLASSIFICATION3
 * CUSTOMER_TAX_CLASSIFICATION3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_TAX_CLASSIFICATION4
 * CUSTOMER_TAX_CLASSIFICATION4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_TAX_CLASSIFICATION5
 * CUSTOMER_TAX_CLASSIFICATION5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_TAX_CLASSIFICATION6
 * CUSTOMER_TAX_CLASSIFICATION6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_TAX_CLASSIFICATION7
 * CUSTOMER_TAX_CLASSIFICATION7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_TAX_CLASSIFICATION8
 * CUSTOMER_TAX_CLASSIFICATION8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_TAX_CLASSIFICATION9
 * CUSTOMER_TAX_CLASSIFICATION9}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_ACCOUNT_ASSIGNMENT_GROUP
 * CUSTOMER_ACCOUNT_ASSIGNMENT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#HEADER_BILLING_BLOCK_REASON
 * HEADER_BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#INCOTERMS_VERSION
 * INCOTERMS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CUSTOMER_PAYMENT_TERMS
 * CUSTOMER_PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#PAYMENT_METHOD
 * PAYMENT_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#BILLING_DOCUMENT_DATE
 * BILLING_DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#SERVICES_RENDERED_DATE
 * SERVICES_RENDERED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#REFERENCE_SD_DOCUMENT
 * REFERENCE_SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#REFERENCE_SD_DOCUMENT_CATEGORY
 * REFERENCE_SD_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#CREDIT_MEMO_REQ_APPROVAL_REASON
 * CREDIT_MEMO_REQ_APPROVAL_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#SALES_DOC_APPROVAL_STATUS
 * SALES_DOC_APPROVAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#OVERALL_SD_PROCESS_STATUS
 * OVERALL_SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#TOTAL_CREDIT_CHECK_STATUS
 * TOTAL_CREDIT_CHECK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#OVERALL_SD_DOCUMENT_REJECTION_STS
 * OVERALL_SD_DOCUMENT_REJECTION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#OVERALL_ORD_RELTD_BILLG_STATUS
 * OVERALL_ORD_RELTD_BILLG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#TO_ITEM
 * TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#TO_SUBSEQUENT_PROC_FLOW_DOC
 * TO_SUBSEQUENT_PROC_FLOW_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface CreditMemoRequestSelectable extends EntitySelectable<CreditMemoRequest>
{

}
