/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.field.CrdtMemoReqItemPartnerSimlnField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.link.CrdtMemoReqItemPartnerSimlnOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.selectable.CrdtMemoReqItemPartnerSimlnSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Partner Simulation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CrdtMemoReqItemPartnerSimlnType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CrdtMemoReqItemPartnerSimln extends VdmEntity<CrdtMemoReqItemPartnerSimln>
{

    /**
     * Selector for all available fields of CrdtMemoReqItemPartnerSimln.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequest</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @Key
    @SerializedName( "CreditMemoRequest" )
    @JsonProperty( "CreditMemoRequest" )
    @Nullable
    @ODataField( odataName = "CreditMemoRequest" )
    private String creditMemoRequest;
    /**
     * Use with available fluent helpers to apply the <b>CreditMemoRequest</b> field to query operations.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnField<String> CREDIT_MEMO_REQUEST =
        new CrdtMemoReqItemPartnerSimlnField<String>("CreditMemoRequest");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequestItem</b>
     * </p>
     *
     * @return Item number of the SD document
     */
    @Key
    @SerializedName( "CreditMemoRequestItem" )
    @JsonProperty( "CreditMemoRequestItem" )
    @Nullable
    @ODataField( odataName = "CreditMemoRequestItem" )
    private String creditMemoRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>CreditMemoRequestItem</b> field to query operations.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnField<String> CREDIT_MEMO_REQUEST_ITEM =
        new CrdtMemoReqItemPartnerSimlnField<String>("CreditMemoRequestItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnField<String> PARTNER_FUNCTION =
        new CrdtMemoReqItemPartnerSimlnField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnField<String> CUSTOMER =
        new CrdtMemoReqItemPartnerSimlnField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnField<String> SUPPLIER =
        new CrdtMemoReqItemPartnerSimlnField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnField<String> PERSONNEL =
        new CrdtMemoReqItemPartnerSimlnField<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Number of Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnField<String> CONTACT_PERSON =
        new CrdtMemoReqItemPartnerSimlnField<String>("ContactPerson");
    /**
     * Navigation property <b>to_CreditMemoRequest</b> for <b>CrdtMemoReqItemPartnerSimln</b> to single
     * <b>CreditMemoRequestSimulation</b>.
     *
     */
    @SerializedName( "to_CreditMemoRequest" )
    @JsonProperty( "to_CreditMemoRequest" )
    @ODataField( odataName = "to_CreditMemoRequest" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CreditMemoRequestSimulation toCreditMemoRequest;
    /**
     * Navigation property <b>to_CreditMemoRequestItem</b> for <b>CrdtMemoReqItemPartnerSimln</b> to single
     * <b>CreditMemoReqItemSimulation</b>.
     *
     */
    @SerializedName( "to_CreditMemoRequestItem" )
    @JsonProperty( "to_CreditMemoRequestItem" )
    @ODataField( odataName = "to_CreditMemoRequestItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CreditMemoReqItemSimulation toCreditMemoRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>to_CreditMemoRequest</b> navigation property to query
     * operations.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnOneToOneLink<CreditMemoRequestSimulation> TO_CREDIT_MEMO_REQUEST =
        new CrdtMemoReqItemPartnerSimlnOneToOneLink<CreditMemoRequestSimulation>("to_CreditMemoRequest");
    /**
     * Use with available fluent helpers to apply the <b>to_CreditMemoRequestItem</b> navigation property to query
     * operations.
     *
     */
    public final static CrdtMemoReqItemPartnerSimlnOneToOneLink<CreditMemoReqItemSimulation> TO_CREDIT_MEMO_REQUEST_ITEM =
        new CrdtMemoReqItemPartnerSimlnOneToOneLink<CreditMemoReqItemSimulation>("to_CreditMemoRequestItem");

    @Nonnull
    @Override
    public Class<CrdtMemoReqItemPartnerSimln> getType()
    {
        return CrdtMemoReqItemPartnerSimln.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequest</b>
     * </p>
     *
     * @param creditMemoRequest
     *            Sales and Distribution Document Number
     */
    public void setCreditMemoRequest( @Nullable final String creditMemoRequest )
    {
        rememberChangedField("CreditMemoRequest", this.creditMemoRequest);
        this.creditMemoRequest = creditMemoRequest;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CreditMemoRequestItem</b>
     * </p>
     *
     * @param creditMemoRequestItem
     *            Item number of the SD document
     */
    public void setCreditMemoRequestItem( @Nullable final String creditMemoRequestItem )
    {
        rememberChangedField("CreditMemoRequestItem", this.creditMemoRequestItem);
        this.creditMemoRequestItem = creditMemoRequestItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Number of Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CrdtMemoReqItemPartnerSimln";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CreditMemoRequest", getCreditMemoRequest());
        result.put("CreditMemoRequestItem", getCreditMemoRequestItem());
        result.put("PartnerFunction", getPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CreditMemoRequest", getCreditMemoRequest());
        values.put("CreditMemoRequestItem", getCreditMemoRequestItem());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("Personnel", getPersonnel());
        values.put("ContactPerson", getContactPerson());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CreditMemoRequest") ) {
                final Object value = values.remove("CreditMemoRequest");
                if( (value == null) || (!value.equals(getCreditMemoRequest())) ) {
                    setCreditMemoRequest(((String) value));
                }
            }
            if( values.containsKey("CreditMemoRequestItem") ) {
                final Object value = values.remove("CreditMemoRequestItem");
                if( (value == null) || (!value.equals(getCreditMemoRequestItem())) ) {
                    setCreditMemoRequestItem(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CreditMemoRequest") ) {
                final Object value = (values).remove("to_CreditMemoRequest");
                if( value instanceof Map ) {
                    if( toCreditMemoRequest == null ) {
                        toCreditMemoRequest = new CreditMemoRequestSimulation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCreditMemoRequest.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CreditMemoRequestItem") ) {
                final Object value = (values).remove("to_CreditMemoRequestItem");
                if( value instanceof Map ) {
                    if( toCreditMemoRequestItem == null ) {
                        toCreditMemoRequestItem = new CreditMemoReqItemSimulation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCreditMemoRequestItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CrdtMemoReqItemPartnerSimlnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CrdtMemoReqItemPartnerSimlnField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CrdtMemoReqItemPartnerSimlnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CrdtMemoReqItemPartnerSimlnField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestSimulateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCreditMemoRequest != null ) {
            (values).put("to_CreditMemoRequest", toCreditMemoRequest);
        }
        if( toCreditMemoRequestItem != null ) {
            (values).put("to_CreditMemoRequestItem", toCreditMemoRequestItem);
        }
        return values;
    }

    /**
     * Fetches the <b>CreditMemoRequestSimulation</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CreditMemoRequest</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CreditMemoRequestSimulation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMemoRequestSimulation fetchCreditMemoRequest()
    {
        return fetchFieldAsSingle("to_CreditMemoRequest", CreditMemoRequestSimulation.class);
    }

    /**
     * Retrieval of associated <b>CreditMemoRequestSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CreditMemoRequest</b>.
     * <p>
     * If the navigation property <b>to_CreditMemoRequest</b> of a queried <b>CrdtMemoReqItemPartnerSimln</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditMemoRequestSimulation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMemoRequestSimulation getCreditMemoRequestOrFetch()
    {
        if( toCreditMemoRequest == null ) {
            toCreditMemoRequest = fetchCreditMemoRequest();
        }
        return toCreditMemoRequest;
    }

    /**
     * Retrieval of associated <b>CreditMemoRequestSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CreditMemoRequest</b>.
     * <p>
     * If the navigation property for an entity <b>CrdtMemoReqItemPartnerSimln</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CreditMemoRequest</b> is already loaded, the result will
     *         contain the <b>CreditMemoRequestSimulation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CreditMemoRequestSimulation> getCreditMemoRequestIfPresent()
    {
        return Option.of(toCreditMemoRequest);
    }

    /**
     * Overwrites the associated <b>CreditMemoRequestSimulation</b> entity for the loaded navigation property
     * <b>to_CreditMemoRequest</b>.
     *
     * @param value
     *            New <b>CreditMemoRequestSimulation</b> entity.
     */
    public void setCreditMemoRequest( final CreditMemoRequestSimulation value )
    {
        toCreditMemoRequest = value;
    }

    /**
     * Fetches the <b>CreditMemoReqItemSimulation</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CreditMemoRequestItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CreditMemoReqItemSimulation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMemoReqItemSimulation fetchCreditMemoRequestItem()
    {
        return fetchFieldAsSingle("to_CreditMemoRequestItem", CreditMemoReqItemSimulation.class);
    }

    /**
     * Retrieval of associated <b>CreditMemoReqItemSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CreditMemoRequestItem</b>.
     * <p>
     * If the navigation property <b>to_CreditMemoRequestItem</b> of a queried <b>CrdtMemoReqItemPartnerSimln</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditMemoReqItemSimulation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMemoReqItemSimulation getCreditMemoRequestItemOrFetch()
    {
        if( toCreditMemoRequestItem == null ) {
            toCreditMemoRequestItem = fetchCreditMemoRequestItem();
        }
        return toCreditMemoRequestItem;
    }

    /**
     * Retrieval of associated <b>CreditMemoReqItemSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CreditMemoRequestItem</b>.
     * <p>
     * If the navigation property for an entity <b>CrdtMemoReqItemPartnerSimln</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CreditMemoRequestItem</b> is already loaded, the result
     *         will contain the <b>CreditMemoReqItemSimulation</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CreditMemoReqItemSimulation> getCreditMemoRequestItemIfPresent()
    {
        return Option.of(toCreditMemoRequestItem);
    }

    /**
     * Overwrites the associated <b>CreditMemoReqItemSimulation</b> entity for the loaded navigation property
     * <b>to_CreditMemoRequestItem</b>.
     *
     * @param value
     *            New <b>CreditMemoReqItemSimulation</b> entity.
     */
    public void setCreditMemoRequestItem( final CreditMemoReqItemSimulation value )
    {
        toCreditMemoRequestItem = value;
    }

    /**
     * Helper class to allow for fluent creation of CrdtMemoReqItemPartnerSimln instances.
     *
     */
    public final static class CrdtMemoReqItemPartnerSimlnBuilder
    {

        private CreditMemoRequestSimulation toCreditMemoRequest;
        private String creditMemoRequest = null;
        private CreditMemoReqItemSimulation toCreditMemoRequestItem;
        private String creditMemoRequestItem = null;

        private CrdtMemoReqItemPartnerSimln.CrdtMemoReqItemPartnerSimlnBuilder toCreditMemoRequest(
            final CreditMemoRequestSimulation value )
        {
            toCreditMemoRequest = value;
            return this;
        }

        /**
         * Navigation property <b>to_CreditMemoRequest</b> for <b>CrdtMemoReqItemPartnerSimln</b> to single
         * <b>CreditMemoRequestSimulation</b>.
         *
         * @param value
         *            The CreditMemoRequestSimulation to build this CrdtMemoReqItemPartnerSimln with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CrdtMemoReqItemPartnerSimln.CrdtMemoReqItemPartnerSimlnBuilder creditMemoRequest(
            final CreditMemoRequestSimulation value )
        {
            return toCreditMemoRequest(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CreditMemoRequest</b>
         * </p>
         *
         * @param value
         *            The creditMemoRequest to build this CrdtMemoReqItemPartnerSimln with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CrdtMemoReqItemPartnerSimln.CrdtMemoReqItemPartnerSimlnBuilder creditMemoRequest( final String value )
        {
            creditMemoRequest = value;
            return this;
        }

        private CrdtMemoReqItemPartnerSimln.CrdtMemoReqItemPartnerSimlnBuilder toCreditMemoRequestItem(
            final CreditMemoReqItemSimulation value )
        {
            toCreditMemoRequestItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CreditMemoRequestItem</b> for <b>CrdtMemoReqItemPartnerSimln</b> to single
         * <b>CreditMemoReqItemSimulation</b>.
         *
         * @param value
         *            The CreditMemoReqItemSimulation to build this CrdtMemoReqItemPartnerSimln with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CrdtMemoReqItemPartnerSimln.CrdtMemoReqItemPartnerSimlnBuilder creditMemoRequestItem(
            final CreditMemoReqItemSimulation value )
        {
            return toCreditMemoRequestItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>CreditMemoRequestItem</b>
         * </p>
         *
         * @param value
         *            The creditMemoRequestItem to build this CrdtMemoReqItemPartnerSimln with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CrdtMemoReqItemPartnerSimln.CrdtMemoReqItemPartnerSimlnBuilder creditMemoRequestItem(
            final String value )
        {
            creditMemoRequestItem = value;
            return this;
        }

    }

}
