/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CreditMemoRequestSimulateServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestSimulateService
 * CreditMemoRequestSimulateService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCreditMemoRequestSimulateServiceBatch
    extends
    BatchFluentHelperBasic<CreditMemoRequestSimulateServiceBatch, CreditMemoRequestSimulateServiceBatchChangeSet>
    implements
    CreditMemoRequestSimulateServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestSimulateService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCreditMemoRequestSimulateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCreditMemoRequestSimulateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestSimulateService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestSimulateService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCreditMemoRequestSimulateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCreditMemoRequestSimulateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestSimulateService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCreditMemoRequestSimulateServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CreditMemoRequestSimulateServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCreditMemoRequestSimulateServiceBatchChangeSet(this, service);
    }

}
