/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoRequestSimulation;

/**
 * Implementation of the {@link CreditMemoRequestSimulateServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestSimulateService
 * CreditMemoRequestSimulateService}.
 *
 */
public class DefaultCreditMemoRequestSimulateServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CreditMemoRequestSimulateServiceBatch, CreditMemoRequestSimulateServiceBatchChangeSet>
    implements
    CreditMemoRequestSimulateServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestSimulateService service;

    @SuppressWarnings( "deprecation" )
    DefaultCreditMemoRequestSimulateServiceBatchChangeSet(
        @Nonnull final DefaultCreditMemoRequestSimulateServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditMemoRequestSimulateService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCreditMemoRequestSimulateServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CreditMemoRequestSimulateServiceBatchChangeSet createCreditMemoRequestSimulation(
        @Nonnull final CreditMemoRequestSimulation creditMemoRequestSimulation )
    {
        return addRequestCreate(service::createCreditMemoRequestSimulation, creditMemoRequestSimulation);
    }

}
