/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln
 * CrdtMemoReqItemPartnerSimln}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.field.CrdtMemoReqItemPartnerSimlnField
 * CrdtMemoReqItemPartnerSimlnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.link.CrdtMemoReqItemPartnerSimlnLink
 * CrdtMemoReqItemPartnerSimlnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln#CREDIT_MEMO_REQUEST
 * CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln#CREDIT_MEMO_REQUEST_ITEM
 * CREDIT_MEMO_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln#TO_CREDIT_MEMO_REQUEST
 * TO_CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CrdtMemoReqItemPartnerSimln#TO_CREDIT_MEMO_REQUEST_ITEM
 * TO_CREDIT_MEMO_REQUEST_ITEM}</li>
 * </ul>
 *
 */
public interface CrdtMemoReqItemPartnerSimlnSelectable extends EntitySelectable<CrdtMemoReqItemPartnerSimln>
{

}
