/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln
 * CreditMemoReqPrcgElmntSimln}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.field.CreditMemoReqPrcgElmntSimlnField
 * CreditMemoReqPrcgElmntSimlnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.link.CreditMemoReqPrcgElmntSimlnLink
 * CreditMemoReqPrcgElmntSimlnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CREDIT_MEMO_REQUEST
 * CREDIT_MEMO_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#PRICE_CONDITION_DETERMINATION_DTE
 * PRICE_CONDITION_DETERMINATION_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_CALCULATION_TYPE
 * CONDITION_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_BASE_VALUE
 * CONDITION_BASE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_TO_BASE_QTY_NMRTR
 * CONDITION_TO_BASE_QTY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_TO_BASE_QTY_DNMNTR
 * CONDITION_TO_BASE_QTY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_CATEGORY
 * CONDITION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_IS_FOR_STATISTICS
 * CONDITION_IS_FOR_STATISTICS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#PRICING_SCALE_TYPE
 * PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#IS_RELEVANT_FOR_ACCRUAL
 * IS_RELEVANT_FOR_ACCRUAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CNDN_IS_RELEVANT_FOR_INVOICE_LIST
 * CNDN_IS_RELEVANT_FOR_INVOICE_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_ORIGIN
 * CONDITION_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#IS_GROUP_CONDITION
 * IS_GROUP_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#ACCESS_NUMBER_OF_ACCESS_SEQUENCE
 * ACCESS_NUMBER_OF_ACCESS_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#WITHHOLDING_TAX_CODE
 * WITHHOLDING_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CNDN_ROUNDING_OFF_DIFF_AMOUNT
 * CNDN_ROUNDING_OFF_DIFF_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_AMOUNT
 * CONDITION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_CONTROL
 * CONDITION_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_INACTIVE_REASON
 * CONDITION_INACTIVE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_CLASS
 * CONDITION_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#PRCG_PROCEDURE_COUNTER_FOR_HEADER
 * PRCG_PROCEDURE_COUNTER_FOR_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#FACTOR_FOR_CONDITION_BASIS_VALUE
 * FACTOR_FOR_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#STRUCTURE_CONDITION
 * STRUCTURE_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE
 * PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#PRICING_SCALE_BASIS
 * PRICING_SCALE_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_SCALE_BASIS_VALUE
 * CONDITION_SCALE_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_SCALE_BASIS_UNIT
 * CONDITION_SCALE_BASIS_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_SCALE_BASIS_CURRENCY
 * CONDITION_SCALE_BASIS_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_ALTERNATIVE_CURRENCY
 * CONDITION_ALTERNATIVE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_AMOUNT_IN_LOCAL_CRCY
 * CONDITION_AMOUNT_IN_LOCAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CNDN_IS_RELEVANT_FOR_INTCO_BILLING
 * CNDN_IS_RELEVANT_FOR_INTCO_BILLING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_IS_MANUALLY_CHANGED
 * CONDITION_IS_MANUALLY_CHANGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CUMULATED_CONDITION_BASIS_VALUE
 * CUMULATED_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#CONDITION_IS_FOR_CONFIGURATION
 * CONDITION_IS_FOR_CONFIGURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#VARIANT_CONDITION
 * VARIANT_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequestsimulate.CreditMemoReqPrcgElmntSimln#TO_CREDIT_MEMO_REQUEST
 * TO_CREDIT_MEMO_REQUEST}</li>
 * </ul>
 *
 */
public interface CreditMemoReqPrcgElmntSimlnSelectable extends EntitySelectable<CreditMemoReqPrcgElmntSimln>
{

}
