/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CustomerAndSupplierIndustryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerAndSupplierIndustryService
 * CustomerAndSupplierIndustryService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultCustomerAndSupplierIndustryServiceBatch
    extends
    BatchFluentHelperBasic<CustomerAndSupplierIndustryServiceBatch, CustomerAndSupplierIndustryServiceBatchChangeSet>
    implements
    CustomerAndSupplierIndustryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerAndSupplierIndustryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCustomerAndSupplierIndustryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerAndSupplierIndustryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerAndSupplierIndustryService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerAndSupplierIndustryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCustomerAndSupplierIndustryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerAndSupplierIndustryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerAndSupplierIndustryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCustomerAndSupplierIndustryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerAndSupplierIndustryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCustomerAndSupplierIndustryServiceBatchChangeSet(this, service);
    }

}
