/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link CustomerAndSupplierIndustryServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerAndSupplierIndustryService
 * CustomerAndSupplierIndustryService}.
 *
 */
public class DefaultCustomerAndSupplierIndustryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CustomerAndSupplierIndustryServiceBatch, CustomerAndSupplierIndustryServiceBatchChangeSet>
    implements
    CustomerAndSupplierIndustryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerAndSupplierIndustryService service;

    @SuppressWarnings( "deprecation" )
    DefaultCustomerAndSupplierIndustryServiceBatchChangeSet(
        @Nonnull final DefaultCustomerAndSupplierIndustryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerAndSupplierIndustryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCustomerAndSupplierIndustryServiceBatchChangeSet getThis()
    {
        return this;
    }

}
