/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustry;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustry
 * CustomerSupplierIndustry}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.field.CustomerSupplierIndustryField
 * CustomerSupplierIndustryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.link.CustomerSupplierIndustryLink
 * CustomerSupplierIndustryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustry#INDUSTRY
 * INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustry#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface CustomerSupplierIndustrySelectable extends EntitySelectable<CustomerSupplierIndustry>
{

}
