/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryText
 * CustomerSupplierIndustryText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.field.CustomerSupplierIndustryTextField
 * CustomerSupplierIndustryTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.link.CustomerSupplierIndustryTextLink
 * CustomerSupplierIndustryTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryText#INDUSTRY
 * INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryText#INDUSTRY_KEY_TEXT
 * INDUSTRY_KEY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerandsupplierindustry.CustomerSupplierIndustryText#TO_CUSTOMER_SUPPLIER_INDUSTRY
 * TO_CUSTOMER_SUPPLIER_INDUSTRY}</li>
 * </ul>
 *
 */
public interface CustomerSupplierIndustryTextSelectable extends EntitySelectable<CustomerSupplierIndustryText>
{

}
