/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.selectable.DownloadFileSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFile DownloadFile}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class DownloadFileByKeyFluentHelper
    extends
    FluentHelperByKey<DownloadFileByKeyFluentHelper, DownloadFile, DownloadFileSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFile
     * DownloadFile} entity with the provided key field values. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code DownloadFile}
     * @param fileName
     *            ZIP File Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code DownloadFile}
     * @param packageName
     *            Package Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     */
    public DownloadFileByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String packageName,
        final String fileName )
    {
        super(servicePath, entityCollection);
        this.key.put("PackageName", packageName);
        this.key.put("FileName", fileName);
    }

    @Override
    @Nonnull
    protected Class<DownloadFile> getEntityClass()
    {
        return DownloadFile.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
