/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.field.FileDownloadStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.selectable.FileDownloadStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * File Download Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FileDownloadStatus</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FileDownloadStatus extends VdmEntity<FileDownloadStatus>
{

    /**
     * Selector for all available fields of FileDownloadStatus.
     *
     */
    public final static FileDownloadStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>PackageName</b>
     * </p>
     *
     * @return Package Name
     */
    @Key
    @SerializedName( "PackageName" )
    @JsonProperty( "PackageName" )
    @Nullable
    @ODataField( odataName = "PackageName" )
    private String packageName;
    /**
     * Use with available fluent helpers to apply the <b>PackageName</b> field to query operations.
     *
     */
    public final static FileDownloadStatusField<String> PACKAGE_NAME =
        new FileDownloadStatusField<String>("PackageName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @return File Name
     */
    @Key
    @SerializedName( "FileName" )
    @JsonProperty( "FileName" )
    @Nullable
    @ODataField( odataName = "FileName" )
    private String fileName;
    /**
     * Use with available fluent helpers to apply the <b>FileName</b> field to query operations.
     *
     */
    public final static FileDownloadStatusField<String> FILE_NAME = new FileDownloadStatusField<String>("FileName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Scenario</b>
     * </p>
     *
     * @return Scenario
     */
    @SerializedName( "Scenario" )
    @JsonProperty( "Scenario" )
    @Nullable
    @ODataField( odataName = "Scenario" )
    private String scenario;
    /**
     * Use with available fluent helpers to apply the <b>Scenario</b> field to query operations.
     *
     */
    public final static FileDownloadStatusField<String> SCENARIO = new FileDownloadStatusField<String>("Scenario");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ObjectName</b>
     * </p>
     *
     * @return Object Name
     */
    @SerializedName( "ObjectName" )
    @JsonProperty( "ObjectName" )
    @Nullable
    @ODataField( odataName = "ObjectName" )
    private String objectName;
    /**
     * Use with available fluent helpers to apply the <b>ObjectName</b> field to query operations.
     *
     */
    public final static FileDownloadStatusField<String> OBJECT_NAME = new FileDownloadStatusField<String>("ObjectName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Failed</b>
     * </p>
     *
     * @return Download Failed
     */
    @SerializedName( "Failed" )
    @JsonProperty( "Failed" )
    @Nullable
    @ODataField( odataName = "Failed" )
    private String failed;
    /**
     * Use with available fluent helpers to apply the <b>Failed</b> field to query operations.
     *
     */
    public final static FileDownloadStatusField<String> FAILED = new FileDownloadStatusField<String>("Failed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InProcess</b>
     * </p>
     *
     * @return Download In Process
     */
    @SerializedName( "InProcess" )
    @JsonProperty( "InProcess" )
    @Nullable
    @ODataField( odataName = "InProcess" )
    private String inProcess;
    /**
     * Use with available fluent helpers to apply the <b>InProcess</b> field to query operations.
     *
     */
    public final static FileDownloadStatusField<String> IN_PROCESS = new FileDownloadStatusField<String>("InProcess");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Finished</b>
     * </p>
     *
     * @return Download Finished
     */
    @SerializedName( "Finished" )
    @JsonProperty( "Finished" )
    @Nullable
    @ODataField( odataName = "Finished" )
    private String finished;
    /**
     * Use with available fluent helpers to apply the <b>Finished</b> field to query operations.
     *
     */
    public final static FileDownloadStatusField<String> FINISHED = new FileDownloadStatusField<String>("Finished");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>DownloadUser</b>
     * </p>
     *
     * @return Download User Name
     */
    @SerializedName( "DownloadUser" )
    @JsonProperty( "DownloadUser" )
    @Nullable
    @ODataField( odataName = "DownloadUser" )
    private String downloadUser;
    /**
     * Use with available fluent helpers to apply the <b>DownloadUser</b> field to query operations.
     *
     */
    public final static FileDownloadStatusField<String> DOWNLOAD_USER =
        new FileDownloadStatusField<String>("DownloadUser");

    @Nonnull
    @Override
    public Class<FileDownloadStatus> getType()
    {
        return FileDownloadStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>PackageName</b>
     * </p>
     *
     * @param packageName
     *            Package Name
     */
    public void setPackageName( @Nullable final String packageName )
    {
        rememberChangedField("PackageName", this.packageName);
        this.packageName = packageName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @param fileName
     *            File Name
     */
    public void setFileName( @Nullable final String fileName )
    {
        rememberChangedField("FileName", this.fileName);
        this.fileName = fileName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Scenario</b>
     * </p>
     *
     * @param scenario
     *            Scenario
     */
    public void setScenario( @Nullable final String scenario )
    {
        rememberChangedField("Scenario", this.scenario);
        this.scenario = scenario;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ObjectName</b>
     * </p>
     *
     * @param objectName
     *            Object Name
     */
    public void setObjectName( @Nullable final String objectName )
    {
        rememberChangedField("ObjectName", this.objectName);
        this.objectName = objectName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Failed</b>
     * </p>
     *
     * @param failed
     *            Download Failed
     */
    public void setFailed( @Nullable final String failed )
    {
        rememberChangedField("Failed", this.failed);
        this.failed = failed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InProcess</b>
     * </p>
     *
     * @param inProcess
     *            Download In Process
     */
    public void setInProcess( @Nullable final String inProcess )
    {
        rememberChangedField("InProcess", this.inProcess);
        this.inProcess = inProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Finished</b>
     * </p>
     *
     * @param finished
     *            Download Finished
     */
    public void setFinished( @Nullable final String finished )
    {
        rememberChangedField("Finished", this.finished);
        this.finished = finished;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>DownloadUser</b>
     * </p>
     *
     * @param downloadUser
     *            Download User Name
     */
    public void setDownloadUser( @Nullable final String downloadUser )
    {
        rememberChangedField("DownloadUser", this.downloadUser);
        this.downloadUser = downloadUser;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FileDownloadStatusSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PackageName", getPackageName());
        result.put("FileName", getFileName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PackageName", getPackageName());
        values.put("FileName", getFileName());
        values.put("Scenario", getScenario());
        values.put("ObjectName", getObjectName());
        values.put("Failed", getFailed());
        values.put("InProcess", getInProcess());
        values.put("Finished", getFinished());
        values.put("DownloadUser", getDownloadUser());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PackageName") ) {
                final Object value = values.remove("PackageName");
                if( (value == null) || (!value.equals(getPackageName())) ) {
                    setPackageName(((String) value));
                }
            }
            if( values.containsKey("FileName") ) {
                final Object value = values.remove("FileName");
                if( (value == null) || (!value.equals(getFileName())) ) {
                    setFileName(((String) value));
                }
            }
            if( values.containsKey("Scenario") ) {
                final Object value = values.remove("Scenario");
                if( (value == null) || (!value.equals(getScenario())) ) {
                    setScenario(((String) value));
                }
            }
            if( values.containsKey("ObjectName") ) {
                final Object value = values.remove("ObjectName");
                if( (value == null) || (!value.equals(getObjectName())) ) {
                    setObjectName(((String) value));
                }
            }
            if( values.containsKey("Failed") ) {
                final Object value = values.remove("Failed");
                if( (value == null) || (!value.equals(getFailed())) ) {
                    setFailed(((String) value));
                }
            }
            if( values.containsKey("InProcess") ) {
                final Object value = values.remove("InProcess");
                if( (value == null) || (!value.equals(getInProcess())) ) {
                    setInProcess(((String) value));
                }
            }
            if( values.containsKey("Finished") ) {
                final Object value = values.remove("Finished");
                if( (value == null) || (!value.equals(getFinished())) ) {
                    setFinished(((String) value));
                }
            }
            if( values.containsKey("DownloadUser") ) {
                final Object value = values.remove("DownloadUser");
                if( (value == null) || (!value.equals(getDownloadUser())) ) {
                    setDownloadUser(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FileDownloadStatusField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FileDownloadStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FileDownloadStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FileDownloadStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService.DEFAULT_SERVICE_PATH);
    }

}
