/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.field.ListFileField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.selectable.ListFileSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Prepared Files
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ListFile</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ListFile extends VdmEntity<ListFile>
{

    /**
     * Selector for all available fields of ListFile.
     *
     */
    public final static ListFileSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>PackageName</b>
     * </p>
     *
     * @return Package Name
     */
    @Key
    @SerializedName( "PackageName" )
    @JsonProperty( "PackageName" )
    @Nullable
    @ODataField( odataName = "PackageName" )
    private String packageName;
    /**
     * Use with available fluent helpers to apply the <b>PackageName</b> field to query operations.
     *
     */
    public final static ListFileField<String> PACKAGE_NAME = new ListFileField<String>("PackageName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @return ZIP File Name
     */
    @Key
    @SerializedName( "FileName" )
    @JsonProperty( "FileName" )
    @Nullable
    @ODataField( odataName = "FileName" )
    private String fileName;
    /**
     * Use with available fluent helpers to apply the <b>FileName</b> field to query operations.
     *
     */
    public final static ListFileField<String> FILE_NAME = new ListFileField<String>("FileName");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ObjectName</b>
     * </p>
     *
     * @return Object Name
     */
    @SerializedName( "ObjectName" )
    @JsonProperty( "ObjectName" )
    @Nullable
    @ODataField( odataName = "ObjectName" )
    private String objectName;
    /**
     * Use with available fluent helpers to apply the <b>ObjectName</b> field to query operations.
     *
     */
    public final static ListFileField<String> OBJECT_NAME = new ListFileField<String>("ObjectName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Scenario</b>
     * </p>
     *
     * @return Scenario
     */
    @SerializedName( "Scenario" )
    @JsonProperty( "Scenario" )
    @Nullable
    @ODataField( odataName = "Scenario" )
    private String scenario;
    /**
     * Use with available fluent helpers to apply the <b>Scenario</b> field to query operations.
     *
     */
    public final static ListFileField<String> SCENARIO = new ListFileField<String>("Scenario");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FileSize</b>
     * </p>
     *
     * @return File Size
     */
    @SerializedName( "FileSize" )
    @JsonProperty( "FileSize" )
    @Nullable
    @ODataField( odataName = "FileSize" )
    private Long fileSize;
    /**
     * Use with available fluent helpers to apply the <b>FileSize</b> field to query operations.
     *
     */
    public final static ListFileField<Long> FILE_SIZE = new ListFileField<Long>("FileSize");

    @Nonnull
    @Override
    public Class<ListFile> getType()
    {
        return ListFile.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>PackageName</b>
     * </p>
     *
     * @param packageName
     *            Package Name
     */
    public void setPackageName( @Nullable final String packageName )
    {
        rememberChangedField("PackageName", this.packageName);
        this.packageName = packageName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @param fileName
     *            ZIP File Name
     */
    public void setFileName( @Nullable final String fileName )
    {
        rememberChangedField("FileName", this.fileName);
        this.fileName = fileName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ObjectName</b>
     * </p>
     *
     * @param objectName
     *            Object Name
     */
    public void setObjectName( @Nullable final String objectName )
    {
        rememberChangedField("ObjectName", this.objectName);
        this.objectName = objectName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Scenario</b>
     * </p>
     *
     * @param scenario
     *            Scenario
     */
    public void setScenario( @Nullable final String scenario )
    {
        rememberChangedField("Scenario", this.scenario);
        this.scenario = scenario;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FileSize</b>
     * </p>
     *
     * @param fileSize
     *            File Size
     */
    public void setFileSize( @Nullable final Long fileSize )
    {
        rememberChangedField("FileSize", this.fileSize);
        this.fileSize = fileSize;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ListFiles";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PackageName", getPackageName());
        result.put("FileName", getFileName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PackageName", getPackageName());
        values.put("FileName", getFileName());
        values.put("ObjectName", getObjectName());
        values.put("Scenario", getScenario());
        values.put("FileSize", getFileSize());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PackageName") ) {
                final Object value = values.remove("PackageName");
                if( (value == null) || (!value.equals(getPackageName())) ) {
                    setPackageName(((String) value));
                }
            }
            if( values.containsKey("FileName") ) {
                final Object value = values.remove("FileName");
                if( (value == null) || (!value.equals(getFileName())) ) {
                    setFileName(((String) value));
                }
            }
            if( values.containsKey("ObjectName") ) {
                final Object value = values.remove("ObjectName");
                if( (value == null) || (!value.equals(getObjectName())) ) {
                    setObjectName(((String) value));
                }
            }
            if( values.containsKey("Scenario") ) {
                final Object value = values.remove("Scenario");
                if( (value == null) || (!value.equals(getScenario())) ) {
                    setScenario(((String) value));
                }
            }
            if( values.containsKey("FileSize") ) {
                final Object value = values.remove("FileSize");
                if( (value == null) || (!value.equals(getFileSize())) ) {
                    setFileSize(((Long) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ListFileField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ListFileField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ListFileField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ListFileField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService.DEFAULT_SERVICE_PATH);
    }

}
