/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CustomerDataReturnFileDownloadServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService
 * CustomerDataReturnFileDownloadService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultCustomerDataReturnFileDownloadServiceBatch
    extends
    BatchFluentHelperBasic<CustomerDataReturnFileDownloadServiceBatch, CustomerDataReturnFileDownloadServiceBatchChangeSet>
    implements
    CustomerDataReturnFileDownloadServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCustomerDataReturnFileDownloadServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerDataReturnFileDownloadServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCustomerDataReturnFileDownloadServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerDataReturnFileDownloadServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCustomerDataReturnFileDownloadServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerDataReturnFileDownloadServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCustomerDataReturnFileDownloadServiceBatchChangeSet(this, service);
    }

}
