/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link CustomerDataReturnFileDownloadServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService
 * CustomerDataReturnFileDownloadService}.
 *
 */
public class DefaultCustomerDataReturnFileDownloadServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CustomerDataReturnFileDownloadServiceBatch, CustomerDataReturnFileDownloadServiceBatchChangeSet>
    implements
    CustomerDataReturnFileDownloadServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService service;

    @SuppressWarnings( "deprecation" )
    DefaultCustomerDataReturnFileDownloadServiceBatchChangeSet(
        @Nonnull final DefaultCustomerDataReturnFileDownloadServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerDataReturnFileDownloadService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCustomerDataReturnFileDownloadServiceBatchChangeSet getThis()
    {
        return this;
    }

}
