/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFile;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFile DownloadFile}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.field.DownloadFileField
 * DownloadFileField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.link.DownloadFileLink
 * DownloadFileLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFile#PACKAGE_NAME
 * PACKAGE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFile#FILE_NAME
 * FILE_NAME}</li>
 * </ul>
 *
 */
public interface DownloadFileSelectable extends EntitySelectable<DownloadFile>
{

}
