/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus
 * FileDownloadStatus}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.field.FileDownloadStatusField
 * FileDownloadStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.link.FileDownloadStatusLink
 * FileDownloadStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus#PACKAGE_NAME
 * PACKAGE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus#FILE_NAME
 * FILE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus#SCENARIO
 * SCENARIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus#OBJECT_NAME
 * OBJECT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus#FAILED
 * FAILED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus#IN_PROCESS
 * IN_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus#FINISHED
 * FINISHED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus#DOWNLOAD_USER
 * DOWNLOAD_USER}</li>
 * </ul>
 *
 */
public interface FileDownloadStatusSelectable extends EntitySelectable<FileDownloadStatus>
{

}
