/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFile;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFile ListFile}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.field.ListFileField
 * ListFileField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.link.ListFileLink
 * ListFileLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFile#PACKAGE_NAME
 * PACKAGE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFile#FILE_NAME
 * FILE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFile#OBJECT_NAME
 * OBJECT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFile#SCENARIO
 * SCENARIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFile#FILE_SIZE
 * FILE_SIZE}</li>
 * </ul>
 *
 */
public interface ListFileSelectable extends EntitySelectable<ListFile>
{

}
