/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.field.CustomerGroupTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.link.CustomerGroupTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.selectable.CustomerGroupTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Customer Group Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerGroupTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerGroupText extends VdmEntity<CustomerGroupText>
{

    /**
     * Selector for all available fields of CustomerGroupText.
     *
     */
    public final static CustomerGroupTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @Key
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static CustomerGroupTextField<String> CUSTOMER_GROUP =
        new CustomerGroupTextField<String>("CustomerGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CustomerGroupTextField<String> LANGUAGE = new CustomerGroupTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupName</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "CustomerGroupName" )
    @JsonProperty( "CustomerGroupName" )
    @Nullable
    @ODataField( odataName = "CustomerGroupName" )
    private String customerGroupName;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroupName</b> field to query operations.
     *
     */
    public final static CustomerGroupTextField<String> CUSTOMER_GROUP_NAME =
        new CustomerGroupTextField<String>("CustomerGroupName");
    /**
     * Navigation property <b>to_CustomerGroup</b> for <b>CustomerGroupText</b> to single <b>CustomerGroup</b>.
     *
     */
    @SerializedName( "to_CustomerGroup" )
    @JsonProperty( "to_CustomerGroup" )
    @ODataField( odataName = "to_CustomerGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CustomerGroup toCustomerGroup;
    /**
     * Use with available fluent helpers to apply the <b>to_CustomerGroup</b> navigation property to query operations.
     *
     */
    public final static CustomerGroupTextOneToOneLink<CustomerGroup> TO_CUSTOMER_GROUP =
        new CustomerGroupTextOneToOneLink<CustomerGroup>("to_CustomerGroup");

    @Nonnull
    @Override
    public Class<CustomerGroupText> getType()
    {
        return CustomerGroupText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupName</b>
     * </p>
     *
     * @param customerGroupName
     *            Description
     */
    public void setCustomerGroupName( @Nullable final String customerGroupName )
    {
        rememberChangedField("CustomerGroupName", this.customerGroupName);
        this.customerGroupName = customerGroupName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerGroupText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerGroup", getCustomerGroup());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerGroup", getCustomerGroup());
        values.put("Language", getLanguage());
        values.put("CustomerGroupName", getCustomerGroupName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CustomerGroupName") ) {
                final Object value = values.remove("CustomerGroupName");
                if( (value == null) || (!value.equals(getCustomerGroupName())) ) {
                    setCustomerGroupName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustomerGroup") ) {
                final Object value = (values).remove("to_CustomerGroup");
                if( value instanceof Map ) {
                    if( toCustomerGroup == null ) {
                        toCustomerGroup = new CustomerGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomerGroup.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerGroupTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerGroupTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerGroupTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerGroupTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerGroupService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustomerGroup != null ) {
            (values).put("to_CustomerGroup", toCustomerGroup);
        }
        return values;
    }

    /**
     * Fetches the <b>CustomerGroup</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CustomerGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CustomerGroup</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerGroup fetchCustomerGroup()
    {
        return fetchFieldAsSingle("to_CustomerGroup", CustomerGroup.class);
    }

    /**
     * Retrieval of associated <b>CustomerGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerGroup</b>.
     * <p>
     * If the navigation property <b>to_CustomerGroup</b> of a queried <b>CustomerGroupText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustomerGroup</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CustomerGroup getCustomerGroupOrFetch()
    {
        if( toCustomerGroup == null ) {
            toCustomerGroup = fetchCustomerGroup();
        }
        return toCustomerGroup;
    }

    /**
     * Retrieval of associated <b>CustomerGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CustomerGroup</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerGroupText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustomerGroup</b> is already loaded, the result will
     *         contain the <b>CustomerGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CustomerGroup> getCustomerGroupIfPresent()
    {
        return Option.of(toCustomerGroup);
    }

    /**
     * Overwrites the associated <b>CustomerGroup</b> entity for the loaded navigation property <b>to_CustomerGroup</b>.
     *
     * @param value
     *            New <b>CustomerGroup</b> entity.
     */
    public void setCustomerGroup( final CustomerGroup value )
    {
        toCustomerGroup = value;
    }

    /**
     * Helper class to allow for fluent creation of CustomerGroupText instances.
     *
     */
    public final static class CustomerGroupTextBuilder
    {

        private CustomerGroup toCustomerGroup;
        private String customerGroup = null;

        private CustomerGroupText.CustomerGroupTextBuilder toCustomerGroup( final CustomerGroup value )
        {
            toCustomerGroup = value;
            return this;
        }

        /**
         * Navigation property <b>to_CustomerGroup</b> for <b>CustomerGroupText</b> to single <b>CustomerGroup</b>.
         *
         * @param value
         *            The CustomerGroup to build this CustomerGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerGroupText.CustomerGroupTextBuilder customerGroup( final CustomerGroup value )
        {
            return toCustomerGroup(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 2
         * <p>
         * Original property name from the Odata EDM: <b>CustomerGroup</b>
         * </p>
         *
         * @param value
         *            The customerGroup to build this CustomerGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerGroupText.CustomerGroupTextBuilder customerGroup( final String value )
        {
            customerGroup = value;
            return this;
        }

    }

}
