/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CustomerGroupServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerGroupService CustomerGroupService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCustomerGroupServiceBatch
    extends
    BatchFluentHelperBasic<CustomerGroupServiceBatch, CustomerGroupServiceBatchChangeSet>
    implements
    CustomerGroupServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerGroupService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCustomerGroupServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerGroupServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerGroupService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerGroupService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCustomerGroupServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerGroupServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerGroupService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCustomerGroupServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerGroupServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCustomerGroupServiceBatchChangeSet(this, service);
    }

}
