/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link CustomerGroupServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerGroupService CustomerGroupService}.
 *
 */
public class DefaultCustomerGroupServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CustomerGroupServiceBatch, CustomerGroupServiceBatchChangeSet>
    implements
    CustomerGroupServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerGroupService service;

    @SuppressWarnings( "deprecation" )
    DefaultCustomerGroupServiceBatchChangeSet(
        @Nonnull final DefaultCustomerGroupServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerGroupService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCustomerGroupServiceBatchChangeSet getThis()
    {
        return this;
    }

}
