/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroup;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroup CustomerGroup}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.field.CustomerGroupField
 * CustomerGroupField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.link.CustomerGroupLink CustomerGroupLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroup#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroup#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface CustomerGroupSelectable extends EntitySelectable<CustomerGroup>
{

}
