/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroupText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroupText CustomerGroupText}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.field.CustomerGroupTextField
 * CustomerGroupTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.link.CustomerGroupTextLink
 * CustomerGroupTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroupText#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroupText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroupText#CUSTOMER_GROUP_NAME
 * CUSTOMER_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customergroup.CustomerGroupText#TO_CUSTOMER_GROUP
 * TO_CUSTOMER_GROUP}</li>
 * </ul>
 *
 */
public interface CustomerGroupTextSelectable extends EntitySelectable<CustomerGroupText>
{

}
