/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.field.CustomerMaterialField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.selectable.CustomerMaterialSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Customer Materials
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerMaterialType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerMaterial extends VdmEntity<CustomerMaterial>
{

    /**
     * Selector for all available fields of CustomerMaterial.
     *
     */
    public final static CustomerMaterialSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @Key
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> SALES_ORGANIZATION =
        new CustomerMaterialField<String>("SalesOrganization");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @Key
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> DISTRIBUTION_CHANNEL =
        new CustomerMaterialField<String>("DistributionChannel");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer number
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> CUSTOMER = new CustomerMaterialField<String>("Customer");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> MATERIAL = new CustomerMaterialField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> MATERIAL_BY_CUSTOMER =
        new CustomerMaterialField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDescriptionByCustomer</b>
     * </p>
     *
     * @return Customer Description of Material
     */
    @SerializedName( "MaterialDescriptionByCustomer" )
    @JsonProperty( "MaterialDescriptionByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialDescriptionByCustomer" )
    private String materialDescriptionByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDescriptionByCustomer</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> MATERIAL_DESCRIPTION_BY_CUSTOMER =
        new CustomerMaterialField<String>("MaterialDescriptionByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant (Own or External)
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> PLANT = new CustomerMaterialField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @return Delivery Priority
     */
    @SerializedName( "DeliveryPriority" )
    @JsonProperty( "DeliveryPriority" )
    @Nullable
    @ODataField( odataName = "DeliveryPriority" )
    private String deliveryPriority;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryPriority</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> DELIVERY_PRIORITY =
        new CustomerMaterialField<String>("DeliveryPriority");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinDeliveryQtyInBaseUnit</b>
     * </p>
     *
     * @return Minimum Delivery Quantity in Delivery Note Processing
     */
    @SerializedName( "MinDeliveryQtyInBaseUnit" )
    @JsonProperty( "MinDeliveryQtyInBaseUnit" )
    @Nullable
    @ODataField( odataName = "MinDeliveryQtyInBaseUnit" )
    private BigDecimal minDeliveryQtyInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MinDeliveryQtyInBaseUnit</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<BigDecimal> MIN_DELIVERY_QTY_IN_BASE_UNIT =
        new CustomerMaterialField<BigDecimal>("MinDeliveryQtyInBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> BASE_UNIT = new CustomerMaterialField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialDeliveryIsAllowed</b>
     * </p>
     *
     * @return Partial Delivery at Item Level
     */
    @SerializedName( "PartialDeliveryIsAllowed" )
    @JsonProperty( "PartialDeliveryIsAllowed" )
    @Nullable
    @ODataField( odataName = "PartialDeliveryIsAllowed" )
    private String partialDeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>PartialDeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> PARTIAL_DELIVERY_IS_ALLOWED =
        new CustomerMaterialField<String>("PartialDeliveryIsAllowed");
    /**
     * Constraints: Not nullable, Precision: 1, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaxNmbrOfPartialDelivery</b>
     * </p>
     *
     * @return Maximum Number of Partial Deliveries Allowed Per Item
     */
    @SerializedName( "MaxNmbrOfPartialDelivery" )
    @JsonProperty( "MaxNmbrOfPartialDelivery" )
    @Nullable
    @ODataField( odataName = "MaxNmbrOfPartialDelivery" )
    private BigDecimal maxNmbrOfPartialDelivery;
    /**
     * Use with available fluent helpers to apply the <b>MaxNmbrOfPartialDelivery</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<BigDecimal> MAX_NMBR_OF_PARTIAL_DELIVERY =
        new CustomerMaterialField<BigDecimal>("MaxNmbrOfPartialDelivery");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Underdelivery Tolerance
     */
    @SerializedName( "UnderdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "UnderdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "UnderdelivTolrtdLmtRatioInPct" )
    private BigDecimal underdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>UnderdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<BigDecimal> UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new CustomerMaterialField<BigDecimal>("UnderdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Overdelivery Tolerance
     */
    @SerializedName( "OverdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "OverdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "OverdelivTolrtdLmtRatioInPct" )
    private BigDecimal overdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>OverdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<BigDecimal> OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new CustomerMaterialField<BigDecimal>("OverdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @return Unlimited Overdelivery Allowed
     */
    @SerializedName( "UnlimitedOverdeliveryIsAllowed" )
    @JsonProperty( "UnlimitedOverdeliveryIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnlimitedOverdeliveryIsAllowed" )
    private Boolean unlimitedOverdeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>UnlimitedOverdeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<Boolean> UNLIMITED_OVERDELIVERY_IS_ALLOWED =
        new CustomerMaterialField<Boolean>("UnlimitedOverdeliveryIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerMaterialItemUsage</b>
     * </p>
     *
     * @return Item Usage
     */
    @SerializedName( "CustomerMaterialItemUsage" )
    @JsonProperty( "CustomerMaterialItemUsage" )
    @Nullable
    @ODataField( odataName = "CustomerMaterialItemUsage" )
    private String customerMaterialItemUsage;
    /**
     * Use with available fluent helpers to apply the <b>CustomerMaterialItemUsage</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> CUSTOMER_MATERIAL_ITEM_USAGE =
        new CustomerMaterialField<String>("CustomerMaterialItemUsage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "SalesUnit" )
    @JsonProperty( "SalesUnit" )
    @Nullable
    @ODataField( odataName = "SalesUnit" )
    private String salesUnit;
    /**
     * Use with available fluent helpers to apply the <b>SalesUnit</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> SALES_UNIT = new CustomerMaterialField<String>("SalesUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator (divisor) for conversion of sales Qty into SKU
     */
    @SerializedName( "SalesQtyToBaseQtyDnmntr" )
    @JsonProperty( "SalesQtyToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "SalesQtyToBaseQtyDnmntr" )
    private BigDecimal salesQtyToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>SalesQtyToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<BigDecimal> SALES_QTY_TO_BASE_QTY_DNMNTR =
        new CustomerMaterialField<BigDecimal>("SalesQtyToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator (factor) for conversion of sales quantity into SKU
     */
    @SerializedName( "SalesQtyToBaseQtyNmrtr" )
    @JsonProperty( "SalesQtyToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "SalesQtyToBaseQtyNmrtr" )
    private BigDecimal salesQtyToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>SalesQtyToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<BigDecimal> SALES_QTY_TO_BASE_QTY_NMRTR =
        new CustomerMaterialField<BigDecimal>("SalesQtyToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerMaterialSearchTerm</b>
     * </p>
     *
     * @return Sort Field
     */
    @SerializedName( "CustomerMaterialSearchTerm" )
    @JsonProperty( "CustomerMaterialSearchTerm" )
    @Nullable
    @ODataField( odataName = "CustomerMaterialSearchTerm" )
    private String customerMaterialSearchTerm;
    /**
     * Use with available fluent helpers to apply the <b>CustomerMaterialSearchTerm</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> CUSTOMER_MATERIAL_SEARCH_TERM =
        new CustomerMaterialField<String>("CustomerMaterialSearchTerm");
    /**
     * Constraints: Not nullable, Maximum length: 27
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @return ETag
     */
    @SerializedName( "ETag" )
    @JsonProperty( "ETag" )
    @Nullable
    @ODataField( odataName = "ETag" )
    private String eTag;
    /**
     * Use with available fluent helpers to apply the <b>ETag</b> field to query operations.
     *
     */
    public final static CustomerMaterialField<String> E_TAG = new CustomerMaterialField<String>("ETag");

    @Nonnull
    @Override
    public Class<CustomerMaterial> getType()
    {
        return CustomerMaterial.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Product Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDescriptionByCustomer</b>
     * </p>
     *
     * @param materialDescriptionByCustomer
     *            Customer Description of Material
     */
    public void setMaterialDescriptionByCustomer( @Nullable final String materialDescriptionByCustomer )
    {
        rememberChangedField("MaterialDescriptionByCustomer", this.materialDescriptionByCustomer);
        this.materialDescriptionByCustomer = materialDescriptionByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant (Own or External)
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @param deliveryPriority
     *            Delivery Priority
     */
    public void setDeliveryPriority( @Nullable final String deliveryPriority )
    {
        rememberChangedField("DeliveryPriority", this.deliveryPriority);
        this.deliveryPriority = deliveryPriority;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinDeliveryQtyInBaseUnit</b>
     * </p>
     *
     * @param minDeliveryQtyInBaseUnit
     *            Minimum Delivery Quantity in Delivery Note Processing
     */
    public void setMinDeliveryQtyInBaseUnit( @Nullable final BigDecimal minDeliveryQtyInBaseUnit )
    {
        rememberChangedField("MinDeliveryQtyInBaseUnit", this.minDeliveryQtyInBaseUnit);
        this.minDeliveryQtyInBaseUnit = minDeliveryQtyInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialDeliveryIsAllowed</b>
     * </p>
     *
     * @param partialDeliveryIsAllowed
     *            Partial Delivery at Item Level
     */
    public void setPartialDeliveryIsAllowed( @Nullable final String partialDeliveryIsAllowed )
    {
        rememberChangedField("PartialDeliveryIsAllowed", this.partialDeliveryIsAllowed);
        this.partialDeliveryIsAllowed = partialDeliveryIsAllowed;
    }

    /**
     * Constraints: Not nullable, Precision: 1, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaxNmbrOfPartialDelivery</b>
     * </p>
     *
     * @param maxNmbrOfPartialDelivery
     *            Maximum Number of Partial Deliveries Allowed Per Item
     */
    public void setMaxNmbrOfPartialDelivery( @Nullable final BigDecimal maxNmbrOfPartialDelivery )
    {
        rememberChangedField("MaxNmbrOfPartialDelivery", this.maxNmbrOfPartialDelivery);
        this.maxNmbrOfPartialDelivery = maxNmbrOfPartialDelivery;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param underdelivTolrtdLmtRatioInPct
     *            Underdelivery Tolerance
     */
    public void setUnderdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal underdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("UnderdelivTolrtdLmtRatioInPct", this.underdelivTolrtdLmtRatioInPct);
        this.underdelivTolrtdLmtRatioInPct = underdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param overdelivTolrtdLmtRatioInPct
     *            Overdelivery Tolerance
     */
    public void setOverdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal overdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("OverdelivTolrtdLmtRatioInPct", this.overdelivTolrtdLmtRatioInPct);
        this.overdelivTolrtdLmtRatioInPct = overdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @param unlimitedOverdeliveryIsAllowed
     *            Unlimited Overdelivery Allowed
     */
    public void setUnlimitedOverdeliveryIsAllowed( @Nullable final Boolean unlimitedOverdeliveryIsAllowed )
    {
        rememberChangedField("UnlimitedOverdeliveryIsAllowed", this.unlimitedOverdeliveryIsAllowed);
        this.unlimitedOverdeliveryIsAllowed = unlimitedOverdeliveryIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerMaterialItemUsage</b>
     * </p>
     *
     * @param customerMaterialItemUsage
     *            Item Usage
     */
    public void setCustomerMaterialItemUsage( @Nullable final String customerMaterialItemUsage )
    {
        rememberChangedField("CustomerMaterialItemUsage", this.customerMaterialItemUsage);
        this.customerMaterialItemUsage = customerMaterialItemUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesUnit</b>
     * </p>
     *
     * @param salesUnit
     *            Sales Unit
     */
    public void setSalesUnit( @Nullable final String salesUnit )
    {
        rememberChangedField("SalesUnit", this.salesUnit);
        this.salesUnit = salesUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @param salesQtyToBaseQtyDnmntr
     *            Denominator (divisor) for conversion of sales Qty into SKU
     */
    public void setSalesQtyToBaseQtyDnmntr( @Nullable final BigDecimal salesQtyToBaseQtyDnmntr )
    {
        rememberChangedField("SalesQtyToBaseQtyDnmntr", this.salesQtyToBaseQtyDnmntr);
        this.salesQtyToBaseQtyDnmntr = salesQtyToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @param salesQtyToBaseQtyNmrtr
     *            Numerator (factor) for conversion of sales quantity into SKU
     */
    public void setSalesQtyToBaseQtyNmrtr( @Nullable final BigDecimal salesQtyToBaseQtyNmrtr )
    {
        rememberChangedField("SalesQtyToBaseQtyNmrtr", this.salesQtyToBaseQtyNmrtr);
        this.salesQtyToBaseQtyNmrtr = salesQtyToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerMaterialSearchTerm</b>
     * </p>
     *
     * @param customerMaterialSearchTerm
     *            Sort Field
     */
    public void setCustomerMaterialSearchTerm( @Nullable final String customerMaterialSearchTerm )
    {
        rememberChangedField("CustomerMaterialSearchTerm", this.customerMaterialSearchTerm);
        this.customerMaterialSearchTerm = customerMaterialSearchTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 27
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @param eTag
     *            ETag
     */
    public void setETag( @Nullable final String eTag )
    {
        rememberChangedField("ETag", this.eTag);
        this.eTag = eTag;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerMaterial";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrganization", getSalesOrganization());
        result.put("DistributionChannel", getDistributionChannel());
        result.put("Customer", getCustomer());
        result.put("Material", getMaterial());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Customer", getCustomer());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("MaterialDescriptionByCustomer", getMaterialDescriptionByCustomer());
        values.put("Plant", getPlant());
        values.put("DeliveryPriority", getDeliveryPriority());
        values.put("MinDeliveryQtyInBaseUnit", getMinDeliveryQtyInBaseUnit());
        values.put("BaseUnit", getBaseUnit());
        values.put("PartialDeliveryIsAllowed", getPartialDeliveryIsAllowed());
        values.put("MaxNmbrOfPartialDelivery", getMaxNmbrOfPartialDelivery());
        values.put("UnderdelivTolrtdLmtRatioInPct", getUnderdelivTolrtdLmtRatioInPct());
        values.put("OverdelivTolrtdLmtRatioInPct", getOverdelivTolrtdLmtRatioInPct());
        values.put("UnlimitedOverdeliveryIsAllowed", getUnlimitedOverdeliveryIsAllowed());
        values.put("CustomerMaterialItemUsage", getCustomerMaterialItemUsage());
        values.put("SalesUnit", getSalesUnit());
        values.put("SalesQtyToBaseQtyDnmntr", getSalesQtyToBaseQtyDnmntr());
        values.put("SalesQtyToBaseQtyNmrtr", getSalesQtyToBaseQtyNmrtr());
        values.put("CustomerMaterialSearchTerm", getCustomerMaterialSearchTerm());
        values.put("ETag", getETag());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("MaterialDescriptionByCustomer") ) {
                final Object value = values.remove("MaterialDescriptionByCustomer");
                if( (value == null) || (!value.equals(getMaterialDescriptionByCustomer())) ) {
                    setMaterialDescriptionByCustomer(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("DeliveryPriority") ) {
                final Object value = values.remove("DeliveryPriority");
                if( (value == null) || (!value.equals(getDeliveryPriority())) ) {
                    setDeliveryPriority(((String) value));
                }
            }
            if( values.containsKey("MinDeliveryQtyInBaseUnit") ) {
                final Object value = values.remove("MinDeliveryQtyInBaseUnit");
                if( (value == null) || (!value.equals(getMinDeliveryQtyInBaseUnit())) ) {
                    setMinDeliveryQtyInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("PartialDeliveryIsAllowed") ) {
                final Object value = values.remove("PartialDeliveryIsAllowed");
                if( (value == null) || (!value.equals(getPartialDeliveryIsAllowed())) ) {
                    setPartialDeliveryIsAllowed(((String) value));
                }
            }
            if( values.containsKey("MaxNmbrOfPartialDelivery") ) {
                final Object value = values.remove("MaxNmbrOfPartialDelivery");
                if( (value == null) || (!value.equals(getMaxNmbrOfPartialDelivery())) ) {
                    setMaxNmbrOfPartialDelivery(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnderdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("UnderdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getUnderdelivTolrtdLmtRatioInPct())) ) {
                    setUnderdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("OverdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("OverdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getOverdelivTolrtdLmtRatioInPct())) ) {
                    setOverdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnlimitedOverdeliveryIsAllowed") ) {
                final Object value = values.remove("UnlimitedOverdeliveryIsAllowed");
                if( (value == null) || (!value.equals(getUnlimitedOverdeliveryIsAllowed())) ) {
                    setUnlimitedOverdeliveryIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("CustomerMaterialItemUsage") ) {
                final Object value = values.remove("CustomerMaterialItemUsage");
                if( (value == null) || (!value.equals(getCustomerMaterialItemUsage())) ) {
                    setCustomerMaterialItemUsage(((String) value));
                }
            }
            if( values.containsKey("SalesUnit") ) {
                final Object value = values.remove("SalesUnit");
                if( (value == null) || (!value.equals(getSalesUnit())) ) {
                    setSalesUnit(((String) value));
                }
            }
            if( values.containsKey("SalesQtyToBaseQtyDnmntr") ) {
                final Object value = values.remove("SalesQtyToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getSalesQtyToBaseQtyDnmntr())) ) {
                    setSalesQtyToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("SalesQtyToBaseQtyNmrtr") ) {
                final Object value = values.remove("SalesQtyToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getSalesQtyToBaseQtyNmrtr())) ) {
                    setSalesQtyToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerMaterialSearchTerm") ) {
                final Object value = values.remove("CustomerMaterialSearchTerm");
                if( (value == null) || (!value.equals(getCustomerMaterialSearchTerm())) ) {
                    setCustomerMaterialSearchTerm(((String) value));
                }
            }
            if( values.containsKey("ETag") ) {
                final Object value = values.remove("ETag");
                if( (value == null) || (!value.equals(getETag())) ) {
                    setETag(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerMaterialField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerMaterialField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerMaterialField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerMaterialField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService.DEFAULT_SERVICE_PATH);
    }

}
