/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService CustomerMaterialService}.
 *
 */
public interface CustomerMaterialServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CustomerMaterialServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CustomerMaterialServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     * CustomerMaterial} entity and save it to the S/4HANA system.
     *
     * @param customerMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *            CustomerMaterial} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerMaterialServiceBatchChangeSet createCustomerMaterial( @Nonnull final CustomerMaterial customerMaterial );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     * CustomerMaterial} entity and save it to the S/4HANA system.
     *
     * @param customerMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *            CustomerMaterial} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerMaterialServiceBatchChangeSet updateCustomerMaterial( @Nonnull final CustomerMaterial customerMaterial );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     * CustomerMaterial} entity in the S/4HANA system.
     *
     * @param customerMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *            CustomerMaterial} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CustomerMaterialServiceBatchChangeSet deleteCustomerMaterial( @Nonnull final CustomerMaterial customerMaterial );

}
