/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CustomerMaterialServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService CustomerMaterialService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCustomerMaterialServiceBatch
    extends
    BatchFluentHelperBasic<CustomerMaterialServiceBatch, CustomerMaterialServiceBatchChangeSet>
    implements
    CustomerMaterialServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCustomerMaterialServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerMaterialServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCustomerMaterialServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCustomerMaterialServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCustomerMaterialServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerMaterialServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCustomerMaterialServiceBatchChangeSet(this, service);
    }

}
