/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial;

/**
 * Implementation of the {@link CustomerMaterialServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService CustomerMaterialService}.
 *
 */
public class DefaultCustomerMaterialServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CustomerMaterialServiceBatch, CustomerMaterialServiceBatchChangeSet>
    implements
    CustomerMaterialServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService service;

    @SuppressWarnings( "deprecation" )
    DefaultCustomerMaterialServiceBatchChangeSet(
        @Nonnull final DefaultCustomerMaterialServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CustomerMaterialService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCustomerMaterialServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CustomerMaterialServiceBatchChangeSet createCustomerMaterial(
        @Nonnull final CustomerMaterial customerMaterial )
    {
        return addRequestCreate(service::createCustomerMaterial, customerMaterial);
    }

    @Nonnull
    @Override
    public CustomerMaterialServiceBatchChangeSet updateCustomerMaterial(
        @Nonnull final CustomerMaterial customerMaterial )
    {
        return addRequestUpdate(service::updateCustomerMaterial, customerMaterial);
    }

    @Nonnull
    @Override
    public CustomerMaterialServiceBatchChangeSet deleteCustomerMaterial(
        @Nonnull final CustomerMaterial customerMaterial )
    {
        return addRequestDelete(service::deleteCustomerMaterial, customerMaterial);
    }

}
